/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.discovery;

import java.lang.reflect.Modifier;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.discovery.CasServerProfile;
import org.apereo.cas.services.AbstractRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.Clients;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class CasServerProfileRegistrar
implements ApplicationContextAware {
    private final CasConfigurationProperties casProperties;
    private final Clients clients;
    private final Set<String> availableAttributes;
    private ApplicationContext applicationContext;

    private static Map<String, Class> locateRegisteredServiceTypesSupported() {
        Function<Class, Object> mapper = c -> {
            try {
                return (RegisteredService)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                return null;
            }
        };
        Collector<RegisteredService, ?, Map<String, Class>> collector = Collectors.toMap(RegisteredService::getFriendlyName, Object::getClass);
        return (Map)CasServerProfileRegistrar.locateSubtypesByReflection(mapper, collector, AbstractRegisteredService.class, o -> true, CentralAuthenticationService.NAMESPACE);
    }

    private static Object locateSubtypesByReflection(Function<Class, Object> mapper, Collector collector, Class parentType, Predicate filter, String packageNamespace) {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage((String)packageNamespace, (ClassLoader[])new ClassLoader[0])).setScanners(new Scanner[]{new SubTypesScanner(false)}));
        Set subTypes = reflections.getSubTypesOf(parentType);
        return subTypes.stream().filter(c -> !Modifier.isInterface(c.getModifiers()) && !Modifier.isAbstract(c.getModifiers()) && filter.test(c)).map(mapper).filter(Objects::nonNull).collect(collector);
    }

    private Map<String, String> locateMultifactorAuthenticationProviderTypesSupported() {
        Map providers = MultifactorAuthenticationUtils.getAvailableMultifactorAuthenticationProviders((ApplicationContext)this.applicationContext);
        return providers.values().stream().collect(Collectors.toMap(MultifactorAuthenticationProvider::getId, MultifactorAuthenticationProvider::getFriendlyName));
    }

    private Set<String> locateDelegatedClientTypesSupported() {
        if (this.clients == null) {
            return new LinkedHashSet<String>(0);
        }
        return this.clients.findAllClients().stream().map(Client::getName).collect(Collectors.toSet());
    }

    public CasServerProfile getProfile() {
        CasServerProfile profile = new CasServerProfile();
        profile.setRegisteredServiceTypesSupported(CasServerProfileRegistrar.locateRegisteredServiceTypesSupported());
        profile.setMultifactorAuthenticationProviderTypesSupported(this.locateMultifactorAuthenticationProviderTypesSupported());
        profile.setDelegatedClientTypesSupported(this.locateDelegatedClientTypesSupported());
        profile.setAvailableAttributes(this.availableAttributes);
        profile.setUserDefinedScopes(this.casProperties.getAuthn().getOidc().getCore().getUserDefinedScopes().keySet());
        return profile;
    }

    @Generated
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Generated
    public CasServerProfileRegistrar(CasConfigurationProperties casProperties, Clients clients, Set<String> availableAttributes) {
        this.casProperties = casProperties;
        this.clients = clients;
        this.availableAttributes = availableAttributes;
    }
}

