/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.jdbc.JdbcAuthenticationProperties;
import org.apereo.cas.discovery.CasServerDiscoveryProfileEndpoint;
import org.apereo.cas.discovery.CasServerProfileRegistrar;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.apereo.services.persondir.IPersonAttributeDaoFilter;
import org.pac4j.core.client.Clients;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="casDiscoveryProfileConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasDiscoveryProfileConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="builtClients")
    private ObjectProvider<Clients> builtClients;
    @Autowired
    @Qualifier(value="authenticationEventExecutionPlan")
    private ObjectProvider<AuthenticationEventExecutionPlan> authenticationEventExecutionPlan;
    @Autowired
    @Qualifier(value="attributeRepository")
    private ObjectProvider<IPersonAttributeDao> attributeRepository;

    private static Set<String> transformAttributes(List<String> attributes) {
        LinkedHashSet<String> attributeSet = new LinkedHashSet<String>(attributes.size());
        CoreAuthenticationUtils.transformPrincipalAttributesListIntoMultiMap(attributes).values().forEach(v -> attributeSet.add(v.toString()));
        return attributeSet;
    }

    @Bean
    public CasServerProfileRegistrar casServerProfileRegistrar() {
        return new CasServerProfileRegistrar(this.casProperties, (Clients)this.builtClients.getIfAvailable(), this.discoveryProfileAvailableAttributes(), (AuthenticationEventExecutionPlan)this.authenticationEventExecutionPlan.getObject());
    }

    @Bean
    @ConditionalOnAvailableEndpoint
    public CasServerDiscoveryProfileEndpoint discoveryProfileEndpoint() {
        return new CasServerDiscoveryProfileEndpoint(this.casProperties, this.casServerProfileRegistrar());
    }

    @Bean
    public Set<String> discoveryProfileAvailableAttributes() {
        JdbcAuthenticationProperties jdbcProps;
        List ldapProps;
        LinkedHashSet<String> attributes = new LinkedHashSet<String>(0);
        Set possibleUserAttributeNames = ((IPersonAttributeDao)this.attributeRepository.getObject()).getPossibleUserAttributeNames(IPersonAttributeDaoFilter.alwaysChoose());
        if (possibleUserAttributeNames != null) {
            attributes.addAll(possibleUserAttributeNames);
        }
        if ((ldapProps = this.casProperties.getAuthn().getLdap()) != null) {
            ldapProps.forEach(ldap -> {
                attributes.addAll(CasDiscoveryProfileConfiguration.transformAttributes(ldap.getPrincipalAttributeList()));
                attributes.addAll(CasDiscoveryProfileConfiguration.transformAttributes(ldap.getAdditionalAttributes()));
            });
        }
        if ((jdbcProps = this.casProperties.getAuthn().getJdbc()) != null) {
            jdbcProps.getQuery().forEach(jdbc -> attributes.addAll(CasDiscoveryProfileConfiguration.transformAttributes(jdbc.getPrincipalAttributeList())));
        }
        return attributes;
    }
}

