/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.duo.config;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.duo.config.cond.ConditionalOnDuoSecurityConfigured;
import org.apereo.cas.authentication.bypass.AuthenticationMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.ChainingMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.CredentialMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.DefaultChainingMultifactorAuthenticationBypassProvider;
import org.apereo.cas.authentication.bypass.GroovyMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.HttpRequestMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.MultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.NeverAllowMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.PrincipalMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.RegisteredServiceMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.RegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.RestMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProviderBypassProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="duoSecurityMultifactorProviderBypassConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnDuoSecurityConfigured
public class DuoSecurityMultifactorProviderBypassConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;

    @ConditionalOnMissingBean(name={"duoSecurityBypassEvaluator"})
    @Bean
    @RefreshScope
    public ChainingMultifactorAuthenticationProviderBypassEvaluator duoSecurityBypassEvaluator() {
        DefaultChainingMultifactorAuthenticationBypassProvider bypass = new DefaultChainingMultifactorAuthenticationBypassProvider();
        bypass.addMultifactorAuthenticationProviderBypassEvaluator(this.duoSecurityRegisteredServiceMultifactorAuthenticationProviderBypass());
        bypass.addMultifactorAuthenticationProviderBypassEvaluator(this.duoSecurityRegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator());
        bypass.addMultifactorAuthenticationProviderBypassEvaluator(this.duoSecurityPrincipalMultifactorAuthenticationProviderBypass());
        bypass.addMultifactorAuthenticationProviderBypassEvaluator(this.duoSecurityAuthenticationMultifactorAuthenticationProviderBypass());
        bypass.addMultifactorAuthenticationProviderBypassEvaluator(this.duoSecurityCredentialMultifactorAuthenticationProviderBypass());
        bypass.addMultifactorAuthenticationProviderBypassEvaluator(this.duoSecurityHttpRequestMultifactorAuthenticationProviderBypass());
        bypass.addMultifactorAuthenticationProviderBypassEvaluator(this.duoSecurityGroovyMultifactorAuthenticationProviderBypass());
        bypass.addMultifactorAuthenticationProviderBypassEvaluator(this.duoSecurityRestMultifactorAuthenticationProviderBypass());
        return bypass;
    }

    @ConditionalOnMissingBean(name={"duoSecurityRestMultifactorAuthenticationProviderBypass"})
    @Bean
    @RefreshScope
    public MultifactorAuthenticationProviderBypassEvaluator duoSecurityRestMultifactorAuthenticationProviderBypass() {
        List duoProps = this.casProperties.getAuthn().getMfa().getDuo();
        DefaultChainingMultifactorAuthenticationBypassProvider bypass = new DefaultChainingMultifactorAuthenticationBypassProvider();
        duoProps.stream().filter(duo -> StringUtils.isNotBlank((CharSequence)duo.getBypass().getRest().getUrl())).forEach(duo -> bypass.addMultifactorAuthenticationProviderBypassEvaluator((MultifactorAuthenticationProviderBypassEvaluator)new RestMultifactorAuthenticationProviderBypassEvaluator(duo.getBypass(), duo.getId())));
        if (bypass.isEmpty()) {
            return NeverAllowMultifactorAuthenticationProviderBypassEvaluator.getInstance();
        }
        return bypass;
    }

    @ConditionalOnMissingBean(name={"duoSecurityGroovyMultifactorAuthenticationProviderBypass"})
    @Bean
    @RefreshScope
    public MultifactorAuthenticationProviderBypassEvaluator duoSecurityGroovyMultifactorAuthenticationProviderBypass() {
        List duoProps = this.casProperties.getAuthn().getMfa().getDuo();
        DefaultChainingMultifactorAuthenticationBypassProvider bypass = new DefaultChainingMultifactorAuthenticationBypassProvider();
        duoProps.stream().filter(duo -> duo.getBypass().getGroovy().getLocation() != null).forEach(duo -> bypass.addMultifactorAuthenticationProviderBypassEvaluator((MultifactorAuthenticationProviderBypassEvaluator)new GroovyMultifactorAuthenticationProviderBypassEvaluator(duo.getBypass(), duo.getId())));
        if (bypass.isEmpty()) {
            return NeverAllowMultifactorAuthenticationProviderBypassEvaluator.getInstance();
        }
        return bypass;
    }

    @ConditionalOnMissingBean(name={"duoSecurityHttpRequestMultifactorAuthenticationProviderBypass"})
    @Bean
    @RefreshScope
    public MultifactorAuthenticationProviderBypassEvaluator duoSecurityHttpRequestMultifactorAuthenticationProviderBypass() {
        List duoProps = this.casProperties.getAuthn().getMfa().getDuo();
        DefaultChainingMultifactorAuthenticationBypassProvider bypass = new DefaultChainingMultifactorAuthenticationBypassProvider();
        duoProps.stream().filter(duo -> {
            MultifactorAuthenticationProviderBypassProperties props = duo.getBypass();
            return StringUtils.isNotBlank((CharSequence)props.getHttpRequestHeaders()) || StringUtils.isNotBlank((CharSequence)props.getHttpRequestRemoteAddress());
        }).forEach(duo -> bypass.addMultifactorAuthenticationProviderBypassEvaluator((MultifactorAuthenticationProviderBypassEvaluator)new HttpRequestMultifactorAuthenticationProviderBypassEvaluator(duo.getBypass(), duo.getId())));
        if (bypass.isEmpty()) {
            return NeverAllowMultifactorAuthenticationProviderBypassEvaluator.getInstance();
        }
        return bypass;
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"duoSecurityCredentialMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator duoSecurityCredentialMultifactorAuthenticationProviderBypass() {
        List duoProps = this.casProperties.getAuthn().getMfa().getDuo();
        DefaultChainingMultifactorAuthenticationBypassProvider bypass = new DefaultChainingMultifactorAuthenticationBypassProvider();
        duoProps.stream().filter(duo -> StringUtils.isNotBlank((CharSequence)duo.getBypass().getCredentialClassType())).forEach(duo -> bypass.addMultifactorAuthenticationProviderBypassEvaluator((MultifactorAuthenticationProviderBypassEvaluator)new CredentialMultifactorAuthenticationProviderBypassEvaluator(duo.getBypass(), duo.getId())));
        if (bypass.isEmpty()) {
            return NeverAllowMultifactorAuthenticationProviderBypassEvaluator.getInstance();
        }
        return bypass;
    }

    @ConditionalOnMissingBean(name={"duoSecurityRegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator"})
    @Bean
    @RefreshScope
    public MultifactorAuthenticationProviderBypassEvaluator duoSecurityRegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator() {
        List duoProps = this.casProperties.getAuthn().getMfa().getDuo();
        DefaultChainingMultifactorAuthenticationBypassProvider bypass = new DefaultChainingMultifactorAuthenticationBypassProvider();
        duoProps.stream().filter(duo -> StringUtils.isNotBlank((CharSequence)duo.getBypass().getCredentialClassType())).forEach(duo -> bypass.addMultifactorAuthenticationProviderBypassEvaluator((MultifactorAuthenticationProviderBypassEvaluator)new RegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator(duo.getId())));
        if (bypass.isEmpty()) {
            return NeverAllowMultifactorAuthenticationProviderBypassEvaluator.getInstance();
        }
        return bypass;
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"duoSecurityRegisteredServiceMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator duoSecurityRegisteredServiceMultifactorAuthenticationProviderBypass() {
        List duoProps = this.casProperties.getAuthn().getMfa().getDuo();
        DefaultChainingMultifactorAuthenticationBypassProvider bypass = new DefaultChainingMultifactorAuthenticationBypassProvider();
        duoProps.forEach(duo -> bypass.addMultifactorAuthenticationProviderBypassEvaluator((MultifactorAuthenticationProviderBypassEvaluator)new RegisteredServiceMultifactorAuthenticationProviderBypassEvaluator(duo.getId())));
        return bypass;
    }

    @Bean
    @ConditionalOnMissingBean(name={"duoSecurityPrincipalMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator duoSecurityPrincipalMultifactorAuthenticationProviderBypass() {
        List duoProps = this.casProperties.getAuthn().getMfa().getDuo();
        DefaultChainingMultifactorAuthenticationBypassProvider bypass = new DefaultChainingMultifactorAuthenticationBypassProvider();
        duoProps.stream().filter(duo -> StringUtils.isNotBlank((CharSequence)duo.getBypass().getPrincipalAttributeName())).forEach(duo -> bypass.addMultifactorAuthenticationProviderBypassEvaluator((MultifactorAuthenticationProviderBypassEvaluator)new PrincipalMultifactorAuthenticationProviderBypassEvaluator(duo.getBypass(), duo.getId())));
        if (bypass.isEmpty()) {
            return NeverAllowMultifactorAuthenticationProviderBypassEvaluator.getInstance();
        }
        return bypass;
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"duoSecurityAuthenticationMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator duoSecurityAuthenticationMultifactorAuthenticationProviderBypass() {
        List duoProps = this.casProperties.getAuthn().getMfa().getDuo();
        DefaultChainingMultifactorAuthenticationBypassProvider bypass = new DefaultChainingMultifactorAuthenticationBypassProvider();
        duoProps.stream().filter(duo -> {
            MultifactorAuthenticationProviderBypassProperties props = duo.getBypass();
            return StringUtils.isNotBlank((CharSequence)props.getAuthenticationAttributeName()) || StringUtils.isNotBlank((CharSequence)props.getAuthenticationHandlerName()) || StringUtils.isNotBlank((CharSequence)props.getAuthenticationMethodName());
        }).forEach(duo -> bypass.addMultifactorAuthenticationProviderBypassEvaluator((MultifactorAuthenticationProviderBypassEvaluator)new AuthenticationMultifactorAuthenticationProviderBypassEvaluator(duo.getBypass(), duo.getId())));
        if (bypass.isEmpty()) {
            return NeverAllowMultifactorAuthenticationProviderBypassEvaluator.getInstance();
        }
        return bypass;
    }
}

