/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.credential;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.warrenstrange.googleauth.IGoogleAuthenticator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.OneTimeTokenAccount;
import org.apereo.cas.configuration.model.support.mfa.gauth.LdapGoogleAuthenticatorMultifactorProperties;
import org.apereo.cas.gauth.credential.BaseGoogleAuthenticatorTokenCredentialRepository;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LdapConnectionFactory;
import org.apereo.cas.util.LdapUtils;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.FilterTemplate;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.SearchResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class LdapGoogleAuthenticatorTokenCredentialRepository
extends BaseGoogleAuthenticatorTokenCredentialRepository
implements DisposableBean {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapGoogleAuthenticatorTokenCredentialRepository.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();
    private final LdapConnectionFactory connectionFactory;
    private final LdapGoogleAuthenticatorMultifactorProperties ldapProperties;

    public LdapGoogleAuthenticatorTokenCredentialRepository(CipherExecutor<String, String> tokenCredentialCipher, CipherExecutor<Number, Number> scratchCodesCipher, IGoogleAuthenticator googleAuthenticator, ConnectionFactory connectionFactory, LdapGoogleAuthenticatorMultifactorProperties ldapProperties) {
        super(tokenCredentialCipher, scratchCodesCipher, googleAuthenticator);
        this.connectionFactory = new LdapConnectionFactory(connectionFactory);
        this.ldapProperties = ldapProperties;
    }

    private static String mapToJson(Collection<OneTimeTokenAccount> acct) {
        return (String)FunctionUtils.doUnchecked(() -> {
            String json = MAPPER.writeValueAsString((Object)acct);
            LOGGER.trace("Transformed object [{}] as JSON value [{}]", (Object)acct, (Object)json);
            return json;
        });
    }

    private static List<OneTimeTokenAccount> mapFromJson(String payload) {
        return (List)FunctionUtils.doUnchecked(() -> {
            LOGGER.trace("Mapping JSON value [{}]", (Object)payload);
            String json = payload.trim();
            if (StringUtils.isNotBlank((CharSequence)json)) {
                return (ArrayList)MAPPER.readValue(json, (TypeReference)new TypeReference<ArrayList<OneTimeTokenAccount>>(){});
            }
            return new ArrayList(0);
        });
    }

    public OneTimeTokenAccount get(long id) {
        return this.load().stream().filter(acct -> acct.getId() == id).findFirst().orElse(null);
    }

    public OneTimeTokenAccount get(String username, long id) {
        return this.get(username).stream().filter(acct -> acct.getId() == id).findFirst().orElse(null);
    }

    public Collection<? extends OneTimeTokenAccount> get(String username) {
        LdapAttribute accounts;
        LdapEntry entry = this.locateLdapEntryFor(username);
        if (entry != null && (accounts = entry.getAttribute(this.ldapProperties.getAccountAttributeName())) != null) {
            LOGGER.debug("Located accounts for [{}] at attribute [{}]", (Object)username, (Object)this.ldapProperties.getAccountAttributeName());
            return accounts.getStringValues().stream().map(LdapGoogleAuthenticatorTokenCredentialRepository::mapFromJson).filter(Objects::nonNull).flatMap(Collection::stream).map(x$0 -> this.decode((OneTimeTokenAccount)x$0)).collect(Collectors.toList());
        }
        return new ArrayList(0);
    }

    public Collection<? extends OneTimeTokenAccount> load() {
        Collection<LdapEntry> entries = this.locateLdapEntriesForAll();
        if (!entries.isEmpty()) {
            return this.mapAccountsFromLdapEntries(entries);
        }
        LOGGER.debug("No decision could be found");
        return new HashSet(0);
    }

    public OneTimeTokenAccount save(OneTimeTokenAccount account) {
        return this.update(account);
    }

    public OneTimeTokenAccount update(OneTimeTokenAccount account) {
        if (account.getId() < 0L) {
            account.setId(RandomUtils.nextLong());
        }
        LOGGER.debug("Storing account [{}]", (Object)account);
        LdapEntry entry = this.locateLdapEntryFor(account.getUsername());
        LdapAttribute ldapAttribute = Objects.requireNonNull(entry, () -> String.format("Unable to locate LDAP entry for %s", account.getUsername())).getAttribute(this.ldapProperties.getAccountAttributeName());
        if (ldapAttribute == null || ldapAttribute.getStringValues().isEmpty()) {
            LOGGER.debug("Adding new account for LDAP entry [{}]", (Object)entry);
            this.updateAccount(account, entry);
        } else {
            Set existingAccounts = ldapAttribute.getStringValues().stream().map(LdapGoogleAuthenticatorTokenCredentialRepository::mapFromJson).filter(Objects::nonNull).flatMap(Collection::stream).map(x$0 -> this.decode((OneTimeTokenAccount)x$0)).collect(Collectors.toSet());
            Optional<OneTimeTokenAccount> matchingAccount = existingAccounts.stream().filter(acct -> acct.getId() == account.getId()).findFirst();
            matchingAccount.ifPresentOrElse(ac -> {
                ac.setValidationCode(account.getValidationCode());
                ac.setScratchCodes(account.getScratchCodes());
                ac.setSecretKey(account.getSecretKey());
            }, () -> existingAccounts.add(account));
            Set<String> accountsToSave = existingAccounts.stream().map(acct -> this.encode(account)).filter(Objects::nonNull).map(acct -> LdapGoogleAuthenticatorTokenCredentialRepository.mapToJson(CollectionUtils.wrapArrayList((Object[])new OneTimeTokenAccount[]{acct}))).collect(Collectors.toSet());
            this.executeModifyOperation(accountsToSave, entry);
        }
        return account;
    }

    public void deleteAll() {
        Collection<LdapEntry> entries = this.locateLdapEntriesForAll();
        entries.forEach(entry -> this.executeModifyOperation(Set.of(), (LdapEntry)entry));
    }

    public void delete(String username) {
        LOGGER.debug("Deleting accounts for principal [{}]", (Object)username);
        LdapEntry entry = this.locateLdapEntryFor(username);
        if (entry != null && this.executeModifyOperation(Set.of(), entry)) {
            LOGGER.debug("Successfully deleted accounts for [{}]", (Object)username);
        }
    }

    public void delete(long id) {
        LdapEntry entry = this.searchLdapAccountsBy(id);
        if (entry != null) {
            List<OneTimeTokenAccount> accounts = this.mapAccountsFromLdapEntries(List.of(entry));
            accounts.removeIf(device -> device.getId() == id);
            this.updateAccounts(accounts, entry);
        }
    }

    public long count() {
        return this.locateLdapEntriesForAll().size();
    }

    public long count(String username) {
        return this.get(username).size();
    }

    public void destroy() {
        this.connectionFactory.close();
    }

    private void updateAccount(OneTimeTokenAccount account, LdapEntry entry) {
        this.updateAccounts(List.of(account), entry);
    }

    private void updateAccounts(Collection<OneTimeTokenAccount> accounts, LdapEntry entry) {
        List<OneTimeTokenAccount> results = accounts.stream().map(x$0 -> this.encode((OneTimeTokenAccount)x$0)).collect(Collectors.toList());
        String json = LdapGoogleAuthenticatorTokenCredentialRepository.mapToJson(results);
        LinkedHashSet<String> entries = new LinkedHashSet<String>();
        entries.add(json);
        this.executeModifyOperation(entries, entry);
    }

    private List<OneTimeTokenAccount> mapAccountsFromLdapEntries(Collection<LdapEntry> entries) {
        return entries.stream().map(e -> e.getAttribute(this.ldapProperties.getAccountAttributeName())).filter(Objects::nonNull).map(attr -> attr.getStringValues().stream().map(LdapGoogleAuthenticatorTokenCredentialRepository::mapFromJson).filter(Objects::nonNull).flatMap(Collection::stream).map(x$0 -> this.decode((OneTimeTokenAccount)x$0)).collect(Collectors.toSet())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private boolean executeModifyOperation(Set<String> accounts, LdapEntry entry) {
        HashMap<String, Set<String>> attrMap = new HashMap<String, Set<String>>();
        attrMap.put(this.ldapProperties.getAccountAttributeName(), accounts);
        LOGGER.debug("Storing records [{}] at LDAP attribute [{}] for [{}]", new Object[]{accounts, attrMap.keySet(), entry.getDn()});
        return this.connectionFactory.executeModifyOperation(entry.getDn(), CollectionUtils.wrap(attrMap));
    }

    private Collection<LdapEntry> locateLdapEntriesForAll() {
        return (Collection)FunctionUtils.doUnchecked(() -> {
            String att = this.ldapProperties.getAccountAttributeName();
            FilterTemplate filter = LdapUtils.newLdaptiveSearchFilter((String)("(" + att + "=*)"));
            LOGGER.debug("Locating LDAP entries via filter [{}] based on attribute [{}]", (Object)filter, (Object)att);
            SearchResponse response = this.connectionFactory.executeSearchOperation(this.ldapProperties.getBaseDn(), filter, this.ldapProperties.getPageSize(), new String[]{att});
            if (LdapUtils.containsResultEntry((SearchResponse)response)) {
                Collection results = response.getEntries();
                LOGGER.debug("Locating [{}] LDAP entries based on response [{}]", (Object)results.size(), (Object)response);
                return results;
            }
            LOGGER.debug("Unable to read entries from LDAP via filter [{}]", (Object)filter);
            return new HashSet(0);
        });
    }

    private LdapEntry locateLdapEntryFor(String principal) {
        return (LdapEntry)FunctionUtils.doUnchecked(() -> {
            String searchFilter = "(" + this.ldapProperties.getSearchFilter() + ")";
            FilterTemplate filter = LdapUtils.newLdaptiveSearchFilter((String)searchFilter, (List)CollectionUtils.wrapList((Object[])new String[]{principal}));
            LOGGER.debug("Locating LDAP entry via filter [{}] based on attribute [{}]", (Object)filter, (Object)this.ldapProperties.getAccountAttributeName());
            SearchResponse response = this.connectionFactory.executeSearchOperation(this.ldapProperties.getBaseDn(), filter, this.ldapProperties.getPageSize(), new String[]{this.ldapProperties.getAccountAttributeName()});
            if (LdapUtils.containsResultEntry((SearchResponse)response)) {
                LdapEntry entry = response.getEntry();
                LOGGER.debug("Located LDAP entry [{}]", (Object)entry);
                return entry;
            }
            return null;
        });
    }

    private LdapEntry searchLdapAccountsBy(long id) {
        return (LdapEntry)FunctionUtils.doUnchecked(() -> {
            String searchFilter = String.format("(%s=*\"id\":%s*)", this.ldapProperties.getAccountAttributeName(), id);
            FilterTemplate filter = LdapUtils.newLdaptiveSearchFilter((String)searchFilter);
            LOGGER.debug("Locating LDAP entry via filter [{}] based on attribute [{}]", (Object)filter, (Object)this.ldapProperties.getAccountAttributeName());
            SearchResponse response = this.connectionFactory.executeSearchOperation(this.ldapProperties.getBaseDn(), filter, this.ldapProperties.getPageSize(), new String[]{this.ldapProperties.getAccountAttributeName()});
            if (LdapUtils.containsResultEntry((SearchResponse)response)) {
                LdapEntry entry = response.getEntry();
                LOGGER.debug("Located LDAP entry [{}]", (Object)entry);
                return entry;
            }
            return null;
        });
    }

    @Generated
    public LdapConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    @Generated
    public LdapGoogleAuthenticatorMultifactorProperties getLdapProperties() {
        return this.ldapProperties;
    }
}

