/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config.support.authentication;

import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.bypass.AuthenticationMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.CredentialMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.DefaultChainingMultifactorAuthenticationBypassProvider;
import org.apereo.cas.authentication.bypass.GroovyMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.HttpRequestMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.MultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.PrincipalMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.RegisteredServiceMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.RegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.RestMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProviderBypassProperties;
import org.apereo.cas.configuration.model.support.mfa.gauth.GoogleAuthenticatorMultifactorAuthenticationProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="googleAuthenticatorMultifactorProviderBypassConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class GoogleAuthenticatorAuthenticationMultifactorProviderBypassConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;

    @ConditionalOnMissingBean(name={"googleAuthenticatorBypassEvaluator"})
    @Bean
    @RefreshScope
    public MultifactorAuthenticationProviderBypassEvaluator googleAuthenticatorBypassEvaluator() {
        DefaultChainingMultifactorAuthenticationBypassProvider bypass = new DefaultChainingMultifactorAuthenticationBypassProvider();
        MultifactorAuthenticationProviderBypassProperties props = this.casProperties.getAuthn().getMfa().getGauth().getBypass();
        if (StringUtils.isNotBlank((CharSequence)props.getPrincipalAttributeName())) {
            bypass.addMultifactorAuthenticationProviderBypassEvaluator(this.googleAuthenticatorPrincipalMultifactorAuthenticationProviderBypass());
        }
        bypass.addMultifactorAuthenticationProviderBypassEvaluator(this.googleAuthenticatorRegisteredServiceMultifactorAuthenticationProviderBypass());
        bypass.addMultifactorAuthenticationProviderBypassEvaluator(this.googleAuthenticatorRegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator());
        if (StringUtils.isNotBlank((CharSequence)props.getAuthenticationAttributeName()) || StringUtils.isNotBlank((CharSequence)props.getAuthenticationHandlerName()) || StringUtils.isNotBlank((CharSequence)props.getAuthenticationMethodName())) {
            bypass.addMultifactorAuthenticationProviderBypassEvaluator(this.googleAuthenticatorAuthenticationMultifactorAuthenticationProviderBypass());
        }
        if (StringUtils.isNotBlank((CharSequence)props.getCredentialClassType())) {
            bypass.addMultifactorAuthenticationProviderBypassEvaluator(this.googleAuthenticatorCredentialMultifactorAuthenticationProviderBypass());
        }
        if (StringUtils.isNotBlank((CharSequence)props.getHttpRequestHeaders()) || StringUtils.isNotBlank((CharSequence)props.getHttpRequestRemoteAddress())) {
            bypass.addMultifactorAuthenticationProviderBypassEvaluator(this.googleAuthenticatorHttpRequestMultifactorAuthenticationProviderBypass());
        }
        if (props.getGroovy().getLocation() != null) {
            bypass.addMultifactorAuthenticationProviderBypassEvaluator(this.googleAuthenticatorGroovyMultifactorAuthenticationProviderBypass());
        }
        if (StringUtils.isNotBlank((CharSequence)props.getRest().getUrl())) {
            bypass.addMultifactorAuthenticationProviderBypassEvaluator(this.googleAuthenticatorRestMultifactorAuthenticationProviderBypass());
        }
        return bypass;
    }

    @ConditionalOnMissingBean(name={"googleAuthenticatorRegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator"})
    @Bean
    @RefreshScope
    public MultifactorAuthenticationProviderBypassEvaluator googleAuthenticatorRegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator() {
        GoogleAuthenticatorMultifactorAuthenticationProperties gauth = this.casProperties.getAuthn().getMfa().getGauth();
        return new RegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator(gauth.getId());
    }

    @ConditionalOnMissingBean(name={"googleAuthenticatorRestMultifactorAuthenticationProviderBypass"})
    @Bean
    @RefreshScope
    public MultifactorAuthenticationProviderBypassEvaluator googleAuthenticatorRestMultifactorAuthenticationProviderBypass() {
        GoogleAuthenticatorMultifactorAuthenticationProperties gauth = this.casProperties.getAuthn().getMfa().getGauth();
        MultifactorAuthenticationProviderBypassProperties props = gauth.getBypass();
        return new RestMultifactorAuthenticationProviderBypassEvaluator(props, gauth.getId());
    }

    @ConditionalOnMissingBean(name={"googleAuthenticatorGroovyMultifactorAuthenticationProviderBypass"})
    @Bean
    @RefreshScope
    public MultifactorAuthenticationProviderBypassEvaluator googleAuthenticatorGroovyMultifactorAuthenticationProviderBypass() {
        GoogleAuthenticatorMultifactorAuthenticationProperties gauth = this.casProperties.getAuthn().getMfa().getGauth();
        MultifactorAuthenticationProviderBypassProperties props = gauth.getBypass();
        return new GroovyMultifactorAuthenticationProviderBypassEvaluator(props, gauth.getId());
    }

    @ConditionalOnMissingBean(name={"googleAuthenticatorHttpRequestMultifactorAuthenticationProviderBypass"})
    @Bean
    @RefreshScope
    public MultifactorAuthenticationProviderBypassEvaluator googleAuthenticatorHttpRequestMultifactorAuthenticationProviderBypass() {
        GoogleAuthenticatorMultifactorAuthenticationProperties gauth = this.casProperties.getAuthn().getMfa().getGauth();
        MultifactorAuthenticationProviderBypassProperties props = gauth.getBypass();
        return new HttpRequestMultifactorAuthenticationProviderBypassEvaluator(props, gauth.getId());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"googleAuthenticatorCredentialMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator googleAuthenticatorCredentialMultifactorAuthenticationProviderBypass() {
        GoogleAuthenticatorMultifactorAuthenticationProperties gauth = this.casProperties.getAuthn().getMfa().getGauth();
        MultifactorAuthenticationProviderBypassProperties props = gauth.getBypass();
        return new CredentialMultifactorAuthenticationProviderBypassEvaluator(props, gauth.getId());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"googleAuthenticatorRegisteredServiceMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator googleAuthenticatorRegisteredServiceMultifactorAuthenticationProviderBypass() {
        GoogleAuthenticatorMultifactorAuthenticationProperties gauth = this.casProperties.getAuthn().getMfa().getGauth();
        return new RegisteredServiceMultifactorAuthenticationProviderBypassEvaluator(gauth.getId());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"googleAuthenticatorPrincipalMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator googleAuthenticatorPrincipalMultifactorAuthenticationProviderBypass() {
        GoogleAuthenticatorMultifactorAuthenticationProperties gauth = this.casProperties.getAuthn().getMfa().getGauth();
        MultifactorAuthenticationProviderBypassProperties props = gauth.getBypass();
        return new PrincipalMultifactorAuthenticationProviderBypassEvaluator(props, gauth.getId());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"googleAuthenticatorAuthenticationMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator googleAuthenticatorAuthenticationMultifactorAuthenticationProviderBypass() {
        GoogleAuthenticatorMultifactorAuthenticationProperties gauth = this.casProperties.getAuthn().getMfa().getGauth();
        MultifactorAuthenticationProviderBypassProperties props = gauth.getBypass();
        return new AuthenticationMultifactorAuthenticationProviderBypassEvaluator(props, gauth.getId());
    }
}

