/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.gauth.web.flow.GoogleAuthenticatorMultifactorTrustedDeviceWebflowConfigurer;
import org.apereo.cas.gauth.web.flow.GoogleAuthenticatorMultifactorWebflowConfigurer;
import org.apereo.cas.trusted.config.ConditionalOnMultifactorTrustedDevicesEnabled;
import org.apereo.cas.trusted.config.MultifactorAuthnTrustConfiguration;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.util.MultifactorAuthenticationWebflowUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.webflow.config.FlowDefinitionRegistryBuilder;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.FlowBuilder;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;

@Configuration(value="googleAuthenticatorConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableScheduling
public class GoogleAuthenticatorConfiguration {
    private static final int WEBFLOW_CONFIGURER_ORDER = 100;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="loginFlowRegistry")
    private ObjectProvider<FlowDefinitionRegistry> loginFlowDefinitionRegistry;
    @Autowired
    private ObjectProvider<FlowBuilderServices> flowBuilderServices;
    @Autowired
    @Qualifier(value="flowBuilder")
    private ObjectProvider<FlowBuilder> flowBuilder;

    @Bean
    @ConditionalOnMissingBean(name={"googleAuthenticatorFlowRegistry"})
    public FlowDefinitionRegistry googleAuthenticatorFlowRegistry() {
        FlowDefinitionRegistryBuilder builder = new FlowDefinitionRegistryBuilder((ApplicationContext)this.applicationContext, (FlowBuilderServices)this.flowBuilderServices.getObject());
        builder.addFlowBuilder((FlowBuilder)this.flowBuilder.getObject(), "mfa-gauth");
        return builder.build();
    }

    @ConditionalOnMissingBean(name={"googleAuthenticatorMultifactorWebflowConfigurer"})
    @Bean
    @DependsOn(value={"defaultWebflowConfigurer"})
    public CasWebflowConfigurer googleAuthenticatorMultifactorWebflowConfigurer() {
        GoogleAuthenticatorMultifactorWebflowConfigurer cfg = new GoogleAuthenticatorMultifactorWebflowConfigurer((FlowBuilderServices)this.flowBuilderServices.getObject(), (FlowDefinitionRegistry)this.loginFlowDefinitionRegistry.getObject(), this.googleAuthenticatorFlowRegistry(), this.applicationContext, this.casProperties, MultifactorAuthenticationWebflowUtils.getMultifactorAuthenticationWebflowCustomizers((ConfigurableApplicationContext)this.applicationContext));
        cfg.setOrder(100);
        return cfg;
    }

    @Bean
    @ConditionalOnMissingBean(name={"googleCasWebflowExecutionPlanConfigurer"})
    public CasWebflowExecutionPlanConfigurer googleCasWebflowExecutionPlanConfigurer() {
        return plan -> plan.registerWebflowConfigurer(this.googleAuthenticatorMultifactorWebflowConfigurer());
    }

    @ConditionalOnClass(value={MultifactorAuthnTrustConfiguration.class})
    @ConditionalOnMultifactorTrustedDevicesEnabled(prefix="cas.authn.mfa.gauth.core")
    @Configuration(value="gauthMultifactorTrustConfiguration")
    public class GoogleAuthenticatorMultifactorTrustConfiguration {
        @ConditionalOnMissingBean(name={"gauthMultifactorTrustWebflowConfigurer"})
        @Bean
        @DependsOn(value={"defaultWebflowConfigurer", "googleAuthenticatorMultifactorWebflowConfigurer"})
        public CasWebflowConfigurer gauthMultifactorTrustWebflowConfigurer() {
            GoogleAuthenticatorMultifactorTrustedDeviceWebflowConfigurer cfg = new GoogleAuthenticatorMultifactorTrustedDeviceWebflowConfigurer((FlowBuilderServices)GoogleAuthenticatorConfiguration.this.flowBuilderServices.getObject(), (FlowDefinitionRegistry)GoogleAuthenticatorConfiguration.this.loginFlowDefinitionRegistry.getObject(), GoogleAuthenticatorConfiguration.this.googleAuthenticatorFlowRegistry(), GoogleAuthenticatorConfiguration.this.applicationContext, GoogleAuthenticatorConfiguration.this.casProperties, MultifactorAuthenticationWebflowUtils.getMultifactorAuthenticationWebflowCustomizers((ConfigurableApplicationContext)GoogleAuthenticatorConfiguration.this.applicationContext));
            cfg.setOrder(101);
            return cfg;
        }

        @Bean
        public CasWebflowExecutionPlanConfigurer gauthMultifactorTrustCasWebflowExecutionPlanConfigurer() {
            return plan -> plan.registerWebflowConfigurer(this.gauthMultifactorTrustWebflowConfigurer());
        }
    }
}

