/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.generic;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Map;
import javax.security.auth.login.AccountExpiredException;
import javax.security.auth.login.AccountLockedException;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import lombok.Generated;
import org.apereo.cas.DefaultMessageDescriptor;
import org.apereo.cas.adaptors.generic.CasUserAccount;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.apereo.cas.authentication.exceptions.AccountDisabledException;
import org.apereo.cas.authentication.exceptions.AccountPasswordMustChangeException;
import org.apereo.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.services.ServicesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class JsonResourceAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonResourceAuthenticationHandler.class);
    private final ObjectMapper mapper;
    private final Resource resource;

    public JsonResourceAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, Integer order, Resource resource) {
        super(name, servicesManager, principalFactory, order);
        this.resource = resource;
        this.mapper = new ObjectMapper().findAndRegisterModules().enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY);
    }

    protected AuthenticationHandlerExecutionResult authenticateUsernamePasswordInternal(UsernamePasswordCredential credential, String originalPassword) throws GeneralSecurityException, PreventedException {
        Map map;
        try {
            map = (Map)this.mapper.readValue(this.resource.getInputStream(), (TypeReference)new TypeReference<Map<String, CasUserAccount>>(){});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new PreventedException((Throwable)e);
        }
        String username = credential.getUsername();
        String password = credential.getPassword();
        if (!map.containsKey(username)) {
            throw new AccountNotFoundException();
        }
        CasUserAccount account = (CasUserAccount)map.get(username);
        if (this.matches(password, account.getPassword())) {
            switch (account.getStatus()) {
                case DISABLED: {
                    throw new AccountDisabledException();
                }
                case EXPIRED: {
                    throw new AccountExpiredException();
                }
                case LOCKED: {
                    throw new AccountLockedException();
                }
                case MUST_CHANGE_PASSWORD: {
                    throw new AccountPasswordMustChangeException();
                }
            }
            LOGGER.debug("Account status is OK");
            ArrayList<DefaultMessageDescriptor> warnings = new ArrayList<DefaultMessageDescriptor>();
            if (account.getExpirationDate() != null) {
                LocalDate warningPeriod;
                LocalDate now = LocalDate.now(ZoneOffset.UTC);
                if (now.isEqual(account.getExpirationDate()) || now.isAfter(account.getExpirationDate())) {
                    throw new AccountExpiredException();
                }
                if (this.getPasswordPolicyConfiguration() != null && (now.isAfter(warningPeriod = account.getExpirationDate().minusDays(this.getPasswordPolicyConfiguration().getPasswordWarningNumberOfDays())) || now.isEqual(warningPeriod))) {
                    long daysRemaining = ChronoUnit.DAYS.between(now, account.getExpirationDate());
                    warnings.add(new DefaultMessageDescriptor("password.expiration.loginsRemaining", "You have {0} logins remaining before you MUST change your password.", new Serializable[]{Long.valueOf(daysRemaining)}));
                }
            }
            Principal principal = this.principalFactory.createPrincipal(username, account.getAttributes());
            return this.createHandlerResult((Credential)credential, principal, warnings);
        }
        throw new FailedLoginException();
    }
}

