/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.interrupt.InterruptInquirer;
import org.apereo.cas.interrupt.webflow.InterruptSingleSignOnParticipationStrategy;
import org.apereo.cas.interrupt.webflow.InterruptWebflowConfigurer;
import org.apereo.cas.interrupt.webflow.actions.FinalizeInterruptFlowAction;
import org.apereo.cas.interrupt.webflow.actions.InquireInterruptAction;
import org.apereo.cas.interrupt.webflow.actions.PrepareInterruptViewAction;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@Configuration(value="casInterruptWebflowConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasInterruptWebflowConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="interruptInquirer")
    private InterruptInquirer interruptInquirer;
    @Autowired
    @Qualifier(value="loginFlowRegistry")
    private FlowDefinitionRegistry loginFlowDefinitionRegistry;
    @Autowired
    private FlowBuilderServices flowBuilderServices;
    @Autowired
    private ApplicationContext applicationContext;

    @ConditionalOnMissingBean(name={"interruptWebflowConfigurer"})
    @Bean
    @DependsOn(value={"defaultWebflowConfigurer"})
    public CasWebflowConfigurer interruptWebflowConfigurer() {
        InterruptWebflowConfigurer w = new InterruptWebflowConfigurer(this.flowBuilderServices, this.loginFlowDefinitionRegistry, this.applicationContext, this.casProperties);
        w.initialize();
        return w;
    }

    @Bean
    public Action inquireInterruptAction() {
        return new InquireInterruptAction(this.interruptInquirer);
    }

    @Bean
    public Action prepareInterruptViewAction() {
        return new PrepareInterruptViewAction();
    }

    @Bean
    public Action finalizeInterruptFlowAction() {
        return new FinalizeInterruptFlowAction();
    }

    @Bean
    @RefreshScope
    public SingleSignOnParticipationStrategy singleSignOnParticipationStrategy() {
        return new InterruptSingleSignOnParticipationStrategy(this.servicesManager, this.casProperties.getSso().isRenewedAuthn());
    }
}

