/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.interrupt.webflow;

import java.util.Map;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.flow.configurer.AbstractCasWebflowConfigurer;
import org.springframework.context.ApplicationContext;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.SubflowState;
import org.springframework.webflow.engine.Transition;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

public class InterruptWebflowConfigurer
extends AbstractCasWebflowConfigurer {
    private static final String INTERRUPT_VIEW_ID = "casInterruptView";
    private static final String VIEW_ID_INTERRUPT_VIEW = "interruptView";
    private static final String STATE_ID_INQUIRE_INTERRUPT_ACTION = "inquireInterruptAction";
    private static final String STATE_ID_FINALIZE_INTERRUPT_ACTION = "finalizeInterruptFlowAction";
    private static final String STATE_ID_PREPARE_INTERRUPT_VIEW_ACTION = "prepareInterruptViewAction";

    public InterruptWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry flowDefinitionRegistry, ApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        super(flowBuilderServices, flowDefinitionRegistry, applicationContext, casProperties);
    }

    protected void doInitialize() {
        Flow flow = this.getLoginFlow();
        if (flow != null) {
            this.createInquireActionState(flow);
            this.createInterruptView(flow);
            this.createTransitionStateToInterrupt(flow);
            this.createTransitionStateForMultifactorSubflows(flow);
            this.createTransitionStateForAuthenticationWarnings(flow);
        }
    }

    private void createTransitionStateForAuthenticationWarnings(Flow flow) {
        ViewState state = (ViewState)this.getState(flow, "showAuthenticationWarningMessages", ViewState.class);
        this.createTransitionForState((TransitionableState)state, "proceed", STATE_ID_INQUIRE_INTERRUPT_ACTION, true);
    }

    private void createTransitionStateToInterrupt(Flow flow) {
        ActionState submit = this.getRealSubmissionState(flow);
        this.createTransitionForState((TransitionableState)submit, "success", STATE_ID_INQUIRE_INTERRUPT_ACTION, true);
    }

    private void createTransitionStateForMultifactorSubflows(Flow flow) {
        Map providerMap = MultifactorAuthenticationUtils.getAvailableMultifactorAuthenticationProviders((ApplicationContext)this.applicationContext);
        providerMap.forEach((k, v) -> {
            if (this.containsSubflowState(flow, v.getId())) {
                SubflowState state = (SubflowState)this.getState(flow, v.getId(), SubflowState.class);
                this.createTransitionForState((TransitionableState)state, "success", STATE_ID_INQUIRE_INTERRUPT_ACTION, true);
            }
        });
    }

    private ActionState getRealSubmissionState(Flow flow) {
        return (ActionState)this.getState(flow, "realSubmit", ActionState.class);
    }

    private void createInterruptView(Flow flow) {
        ViewState viewState = this.createViewState(flow, VIEW_ID_INTERRUPT_VIEW, INTERRUPT_VIEW_ID);
        viewState.getEntryActionList().add((Action)this.createEvaluateAction(STATE_ID_PREPARE_INTERRUPT_VIEW_ACTION));
        this.createStateDefaultTransition((TransitionableState)viewState, STATE_ID_FINALIZE_INTERRUPT_ACTION);
        String target = this.getRealSubmissionState(flow).getTransition("success").getTargetStateId();
        ActionState finalizeInterrupt = this.createActionState(flow, STATE_ID_FINALIZE_INTERRUPT_ACTION, (Action)this.createEvaluateAction(STATE_ID_FINALIZE_INTERRUPT_ACTION));
        this.createTransitionForState((TransitionableState)finalizeInterrupt, "success", target);
        this.createTransitionForState((TransitionableState)finalizeInterrupt, "no", "finishedInterrupt");
        this.createEndState(flow, "finishedInterrupt");
    }

    private void createInquireActionState(Flow flow) {
        ActionState actionState = this.createActionState(flow, STATE_ID_INQUIRE_INTERRUPT_ACTION, (Action)this.createEvaluateAction(STATE_ID_INQUIRE_INTERRUPT_ACTION));
        String target = this.getRealSubmissionState(flow).getTransition("success").getTargetStateId();
        Transition noInterruptTransition = this.createTransition("no", target);
        actionState.getTransitionSet().add(noInterruptTransition);
        Transition yesInterruptTransition = this.createTransition("yes", VIEW_ID_INTERRUPT_VIEW);
        actionState.getTransitionSet().add(yesInterruptTransition);
    }
}

