/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.interrupt.webflow.actions;

import org.apereo.cas.interrupt.InterruptResponse;
import org.apereo.cas.interrupt.webflow.InterruptUtils;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class FinalizeInterruptFlowAction
extends AbstractAction {
    protected Event doExecute(RequestContext requestContext) throws Exception {
        RegisteredService registeredService = WebUtils.getRegisteredService((RequestContext)requestContext);
        InterruptResponse response = InterruptUtils.getInterruptFrom(requestContext);
        if (response.isBlock()) {
            if (registeredService != null && registeredService.getAccessStrategy().getUnauthorizedRedirectUrl() != null) {
                String url = registeredService.getAccessStrategy().getUnauthorizedRedirectUrl().toURL().toExternalForm();
                requestContext.getExternalContext().requestExternalRedirect(url);
                requestContext.getExternalContext().recordResponseComplete();
                return this.no();
            }
            throw new UnauthorizedServiceException("screen.service.error.message", "Denied");
        }
        return this.success();
    }
}

