/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.interrupt.webflow.actions;

import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.interrupt.InterruptInquirer;
import org.apereo.cas.interrupt.InterruptResponse;
import org.apereo.cas.interrupt.webflow.InterruptUtils;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class InquireInterruptAction
extends AbstractAction {
    private final InterruptInquirer interruptInquirer;

    public InquireInterruptAction(InterruptInquirer interruptInquirer) {
        this.interruptInquirer = interruptInquirer;
    }

    protected Event doExecute(RequestContext requestContext) {
        Authentication authentication = WebUtils.getAuthentication((RequestContext)requestContext);
        WebApplicationService service = WebUtils.getService((RequestContext)requestContext);
        RegisteredService registeredService = WebUtils.getRegisteredService((RequestContext)requestContext);
        InterruptResponse response = this.interruptInquirer.inquire(authentication, registeredService, (Service)service);
        if (response == null || !response.isInterrupt()) {
            return this.no();
        }
        InterruptUtils.putInterruptIn(requestContext, response);
        WebUtils.putPrincipal((RequestContext)requestContext, (Principal)authentication.getPrincipal());
        return this.yes();
    }
}

