/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.jdbc;

import java.security.GeneralSecurityException;
import java.util.ArrayList;
import javax.security.auth.login.FailedLoginException;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.jdbc.AbstractJdbcUsernamePasswordAuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.services.ServicesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;

public class SearchModeSearchDatabaseAuthenticationHandler
extends AbstractJdbcUsernamePasswordAuthenticationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchModeSearchDatabaseAuthenticationHandler.class);
    private final String fieldUser;
    private final String fieldPassword;
    private final String tableUsers;

    public SearchModeSearchDatabaseAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, Integer order, DataSource datasource, String fieldUser, String fieldPassword, String tableUsers) {
        super(name, servicesManager, principalFactory, order, datasource);
        this.fieldUser = fieldUser;
        this.fieldPassword = fieldPassword;
        this.tableUsers = tableUsers;
    }

    protected AuthenticationHandlerExecutionResult authenticateUsernamePasswordInternal(UsernamePasswordCredential credential, String originalPassword) throws GeneralSecurityException, PreventedException {
        String sql = null;
        if (StringUtils.isNotBlank((CharSequence)this.tableUsers) || StringUtils.isNotBlank((CharSequence)this.fieldUser) || StringUtils.isNotBlank((CharSequence)this.fieldPassword)) {
            sql = "SELECT COUNT('x') FROM ".concat(this.tableUsers).concat(" WHERE ").concat(this.fieldUser).concat(" = ? AND ").concat(this.fieldPassword).concat("= ?");
        }
        if (StringUtils.isBlank(sql) || this.getJdbcTemplate() == null) {
            throw new GeneralSecurityException("Authentication handler is not configured correctly. No SQL statement or JDBC template found");
        }
        String username = credential.getUsername();
        try {
            LOGGER.debug("Executing SQL query [{}]", (Object)sql);
            int count = (Integer)this.getJdbcTemplate().queryForObject(sql, Integer.class, new Object[]{username, credential.getPassword()});
            if (count == 0) {
                throw new FailedLoginException(username + " not found with SQL query.");
            }
            return this.createHandlerResult((Credential)credential, this.principalFactory.createPrincipal(username), new ArrayList(0));
        }
        catch (DataAccessException e) {
            throw new PreventedException("SQL exception while executing query for " + username, (Throwable)e);
        }
    }
}

