/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas;

import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.annotation.WebListener;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apereo.cas.CentralAuthenticationService;

@WebListener
public class JdbcServletContextListener
implements ServletContextListener {
    public final void contextDestroyed(ServletContextEvent sce) {
        Logger logger = Logger.getLogger(CentralAuthenticationService.NAMESPACE);
        logger.fine("Unregistering JDBC drivers...");
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Iterator<Driver> drivers = DriverManager.getDrivers().asIterator();
        while (drivers.hasNext()) {
            Driver driver = drivers.next();
            if (driver.getClass().getClassLoader() == cl) {
                try {
                    logger.fine("Attempting to deregister JDBC driver " + String.valueOf(driver));
                    DriverManager.deregisterDriver(driver);
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, "Error deregistering JDBC driver ", ex);
                }
                continue;
            }
            logger.fine("Not deregistering JDBC driver as it does not belong to this classloader: " + String.valueOf(driver));
        }
    }
}

