/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.hibernate;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Stream;
import javax.persistence.TypedQuery;
import javax.persistence.spi.PersistenceProvider;
import lombok.Generated;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.model.support.jpa.DatabaseProperties;
import org.apereo.cas.configuration.model.support.jpa.JpaConfigurationContext;
import org.apereo.cas.configuration.support.JpaBeans;
import org.apereo.cas.hibernate.CasHibernatePersistenceProvider;
import org.apereo.cas.jpa.JpaBeanFactory;
import org.apereo.cas.jpa.JpaPersistenceProviderConfigurer;
import org.apereo.cas.jpa.JpaPersistenceProviderContext;
import org.apereo.cas.util.LoggingUtils;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;

public class CasHibernateJpaBeanFactory
implements JpaBeanFactory {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasHibernateJpaBeanFactory.class);
    private final ConfigurableApplicationContext applicationContext;

    public JpaVendorAdapter newJpaVendorAdapter(DatabaseProperties databaseProperties) {
        HibernateJpaVendorAdapter bean = new HibernateJpaVendorAdapter();
        bean.setGenerateDdl(databaseProperties.isGenDdl());
        bean.setShowSql(databaseProperties.isShowSql());
        return bean;
    }

    public LocalContainerEntityManagerFactoryBean newEntityManagerFactoryBean(JpaConfigurationContext config, AbstractJpaProperties jpaProperties) {
        Properties properties = new Properties();
        properties.put("hibernate.dialect", jpaProperties.getDialect());
        properties.put("hibernate.hbm2ddl.auto", jpaProperties.getDdlAuto());
        properties.put("hibernate.jdbc.batch_size", (Object)jpaProperties.getBatchSize());
        properties.put("hibernate.generate_statistics", (Object)jpaProperties.isGenerateStatistics());
        if (StringUtils.isNotBlank((CharSequence)jpaProperties.getDefaultCatalog())) {
            properties.put("hibernate.default_catalog", jpaProperties.getDefaultCatalog());
        }
        if (StringUtils.isNotBlank((CharSequence)jpaProperties.getDefaultSchema())) {
            properties.put("hibernate.default_schema", jpaProperties.getDefaultSchema());
        }
        properties.put("hibernate.enable_lazy_load_no_trans", Boolean.TRUE);
        properties.put("hibernate.format_sql", Boolean.TRUE);
        properties.put("hibernate.connection.useUnicode", Boolean.TRUE);
        properties.put("hibernate.connection.characterEncoding", StandardCharsets.UTF_8.name());
        properties.put("hibernate.connection.charSet", StandardCharsets.UTF_8.name());
        properties.put("hibernate.connection.autocommit", (Object)jpaProperties.isAutocommit());
        properties.put("hibernate.jdbc.time_zone", "UTC");
        properties.put("hibernate.jdbc.fetch_size", (Object)jpaProperties.getFetchSize());
        if (StringUtils.isNotBlank((CharSequence)jpaProperties.getPhysicalNamingStrategyClassName())) {
            try {
                Class clazz = ClassUtils.getClass((ClassLoader)JpaBeans.class.getClassLoader(), (String)jpaProperties.getPhysicalNamingStrategyClassName());
                PhysicalNamingStrategy namingStrategy = (PhysicalNamingStrategy)PhysicalNamingStrategy.class.cast(clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                if (namingStrategy instanceof ApplicationContextAware) {
                    ((ApplicationContextAware)namingStrategy).setApplicationContext((ApplicationContext)this.applicationContext);
                }
                properties.put("hibernate.physical_naming_strategy", namingStrategy);
            }
            catch (Exception e) {
                LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            }
        }
        properties.putAll((Map<?, ?>)jpaProperties.getProperties());
        LocalContainerEntityManagerFactoryBean bean = JpaBeans.newEntityManagerFactoryBean((JpaConfigurationContext)config);
        bean.setJpaProperties(properties);
        return bean;
    }

    public PersistenceProvider newPersistenceProvider(AbstractJpaProperties jpa) {
        Collection configurers = this.applicationContext.getBeansOfType(JpaPersistenceProviderConfigurer.class, false, true).values();
        AnnotationAwareOrderComparator.sortIfNecessary(configurers);
        JpaPersistenceProviderContext context = new JpaPersistenceProviderContext();
        configurers.forEach(cfg -> cfg.configure(context));
        return new CasHibernatePersistenceProvider(context);
    }

    public Stream<? extends Serializable> streamQuery(TypedQuery<? extends Serializable> query) {
        Query hibernateQuery = (Query)Query.class.cast(query);
        return hibernateQuery.stream();
    }

    @Generated
    public CasHibernateJpaBeanFactory(ConfigurableApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

