/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.jpa;

import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.scripting.ScriptingUtils;
import org.apereo.cas.util.spring.ApplicationContextProvider;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.orm.jpa.hibernate.SpringPhysicalNamingStrategy;
import org.springframework.core.io.Resource;

public class CasHibernatePhysicalNamingStrategy
extends SpringPhysicalNamingStrategy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasHibernatePhysicalNamingStrategy.class);

    public Identifier toPhysicalTableName(Identifier name, JdbcEnvironment jdbcEnvironment) {
        Optional propsResult = ApplicationContextProvider.getCasProperties();
        if (propsResult.isEmpty()) {
            LOGGER.error("Could not load configuration settings. CAS application context may not have initialized correctly.");
            return super.toPhysicalTableName(name, jdbcEnvironment);
        }
        String tableName = name.getCanonicalName();
        CasConfigurationProperties casProperties = (CasConfigurationProperties)propsResult.get();
        Map tableNames = casProperties.getJdbc().getPhysicalTableNames();
        if (tableNames.isEmpty()) {
            LOGGER.trace("No configured table names are defined to map [{}]", (Object)tableName);
            return super.toPhysicalTableName(name, jdbcEnvironment);
        }
        LOGGER.trace("Locating physical table name for [{}] based on configured table names [{}]", (Object)tableName, (Object)tableNames);
        if (tableNames.containsKey(tableName)) {
            String physicalName = (String)tableNames.get(tableName);
            if (ScriptingUtils.isExternalGroovyScript((String)physicalName)) {
                LOGGER.trace("Executing script [{}] to determine physical table name for [{}]", (Object)physicalName, (Object)tableName);
                Resource scriptResource = ApplicationContextProvider.getResourceLoader().getResource(physicalName);
                Object[] args = new Object[]{name, jdbcEnvironment, ApplicationContextProvider.getApplicationContext(), LOGGER};
                Identifier identifier = (Identifier)ScriptingUtils.executeGroovyScript((Resource)scriptResource, (Object[])args, Identifier.class, (boolean)true);
                LOGGER.trace("Determine table physical name from script [{}] to be [{}]", (Object)scriptResource, (Object)identifier);
                return identifier;
            }
            LOGGER.trace("Located physical table name [{}] for [{}]", (Object)physicalName, (Object)tableName);
            return Identifier.toIdentifier((String)physicalName);
        }
        return super.toPhysicalTableName(name, jdbcEnvironment);
    }

    protected boolean isCaseInsensitive(JdbcEnvironment jdbcEnvironment) {
        Optional propsResult = ApplicationContextProvider.getCasProperties();
        if (propsResult.isEmpty()) {
            LOGGER.error("Could not load configuration settings to determine case insensitivity.");
            return super.isCaseInsensitive(jdbcEnvironment);
        }
        CasConfigurationProperties casProperties = (CasConfigurationProperties)propsResult.get();
        return casProperties.getJdbc().isCaseInsensitive();
    }
}

