/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.LdapAuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.ldap.LdapAuthenticationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.LdapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.SetFactoryBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="ldapAuthenticationConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class LdapAuthenticationConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapAuthenticationConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="defaultPrincipalResolver")
    private ObjectProvider<PrincipalResolver> defaultPrincipalResolver;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;

    @ConditionalOnMissingBean(name={"ldapPrincipalFactory"})
    @Bean
    @RefreshScope
    public PrincipalFactory ldapPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @Bean
    public SetFactoryBean ldapAuthenticationHandlerSetFactoryBean() {
        return LdapUtils.createLdapAuthenticationFactoryBean();
    }

    @Bean
    @RefreshScope
    public Collection<AuthenticationHandler> ldapAuthenticationHandlers(@Qualifier(value="ldapAuthenticationHandlerSetFactoryBean") SetFactoryBean ldapAuthenticationHandlerSetFactoryBean) {
        HashSet<AuthenticationHandler> handlers = new HashSet<AuthenticationHandler>();
        this.casProperties.getAuthn().getLdap().stream().filter(l -> {
            if (l.getType() == null || StringUtils.isBlank((CharSequence)l.getLdapUrl())) {
                LOGGER.warn("Skipping LDAP authentication entry since no type or LDAP url is defined");
                return false;
            }
            return true;
        }).forEach(l -> {
            LdapAuthenticationHandler handler = LdapUtils.createLdapAuthenticationHandler((LdapAuthenticationProperties)l, (ApplicationContext)this.applicationContext, (ServicesManager)((ServicesManager)this.servicesManager.getObject()), (PrincipalFactory)this.ldapPrincipalFactory());
            handler.setState(l.getState());
            handlers.add((AuthenticationHandler)handler);
        });
        ((Set)ldapAuthenticationHandlerSetFactoryBean.getObject()).addAll(handlers);
        return handlers;
    }

    @ConditionalOnMissingBean(name={"ldapAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    @Autowired
    @RefreshScope
    public AuthenticationEventExecutionPlanConfigurer ldapAuthenticationEventExecutionPlanConfigurer(@Qualifier(value="ldapAuthenticationHandlerSetFactoryBean") SetFactoryBean ldapAuthenticationHandlerSetFactoryBean) {
        return plan -> this.ldapAuthenticationHandlers(ldapAuthenticationHandlerSetFactoryBean).forEach(handler -> {
            LOGGER.info("Registering LDAP authentication for [{}]", (Object)handler.getName());
            plan.registerAuthenticationHandlerWithPrincipalResolver(handler, (PrincipalResolver)this.defaultPrincipalResolver.getObject());
        });
    }
}

