/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationPostProcessor;
import org.apereo.cas.authentication.LdapPasswordSynchronizationAuthenticationPostProcessor;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.passwordsync.LdapPasswordSynchronizationProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapSearchProperties;
import org.jooq.lambda.Unchecked;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.ListFactoryBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="ldapPasswordSynchronizationConfiguration", proxyBeanMethods=true)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnProperty(prefix="cas.authn.password-sync", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class LdapPasswordSynchronizationConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;

    @Bean
    public ListFactoryBean ldapPasswordSynchronizationAuthenticationPostProcessorListFactoryBean() {
        ListFactoryBean bean = new ListFactoryBean(){

            protected void destroyInstance(List list) {
                Objects.requireNonNull(list).forEach(Unchecked.consumer(postProcessor -> ((DisposableBean)postProcessor).destroy()));
            }
        };
        bean.setSourceList(new ArrayList());
        return bean;
    }

    @ConditionalOnMissingBean(name={"ldapPasswordSynchronizationAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    @Autowired
    public AuthenticationEventExecutionPlanConfigurer ldapPasswordSynchronizationAuthenticationEventExecutionPlanConfigurer(@Qualifier(value="ldapPasswordSynchronizationAuthenticationPostProcessorListFactoryBean") ListFactoryBean ldapPasswordSynchronizationAuthenticationPostProcessorListFactoryBean) {
        List postProcessorList = Objects.requireNonNull((List)ldapPasswordSynchronizationAuthenticationPostProcessorListFactoryBean.getObject());
        return plan -> {
            List ldap = this.casProperties.getAuthn().getPasswordSync().getLdap();
            ldap.stream().filter(LdapPasswordSynchronizationProperties::isEnabled).forEach(instance -> {
                LdapPasswordSynchronizationAuthenticationPostProcessor postProcessor = new LdapPasswordSynchronizationAuthenticationPostProcessor((AbstractLdapSearchProperties)instance);
                postProcessorList.add(postProcessor);
                plan.registerAuthenticationPostProcessor((AuthenticationPostProcessor)postProcessor);
            });
        };
    }
}

