/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Slf4jReporter;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.codahale.metrics.jvm.FileDescriptorRatioGauge;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import com.ryantenney.metrics.spring.config.annotation.EnableMetrics;
import com.ryantenney.metrics.spring.config.annotation.MetricsConfigurerAdapter;
import java.io.Closeable;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.support.Beans;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="casMetricsConfiguration")
@EnableMetrics
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasMetricsConfiguration
extends MetricsConfigurerAdapter {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasMetricsConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;

    @RefreshScope
    @Bean
    public MetricRegistry metrics() {
        MetricRegistry metrics = new MetricRegistry();
        metrics.register("jvm.gc", (Metric)new GarbageCollectorMetricSet());
        metrics.register("jvm.memory", (Metric)new MemoryUsageGaugeSet());
        metrics.register("thread-states", (Metric)new ThreadStatesGaugeSet());
        metrics.register("jvm.fd.usage", (Metric)new FileDescriptorRatioGauge());
        return metrics;
    }

    @Bean
    public HealthCheckRegistry healthCheckMetrics() {
        return new HealthCheckRegistry();
    }

    public MetricRegistry getMetricRegistry() {
        return this.metrics();
    }

    public HealthCheckRegistry getHealthCheckRegistry() {
        return this.healthCheckMetrics();
    }

    public void configureReporters(MetricRegistry metricRegistry) {
        Logger perfStatsLogger = LoggerFactory.getLogger((String)this.casProperties.getMetrics().getLoggerName());
        ((Slf4jReporter)this.registerReporter((Closeable)Slf4jReporter.forRegistry((MetricRegistry)metricRegistry).outputTo(perfStatsLogger).convertRatesTo(TimeUnit.MILLISECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build())).start(Beans.newDuration((String)this.casProperties.getMetrics().getRefreshInterval()).getSeconds(), TimeUnit.SECONDS);
        this.registerReporter((Closeable)JmxReporter.forRegistry((MetricRegistry)metricRegistry).build());
    }
}

