/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategy;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.web.flow.OAuth20RegisteredServiceUIAction;
import org.apereo.cas.support.oauth.web.flow.OAuth20WebflowConfigurer;
import org.apereo.cas.validation.CasProtocolViewFactory;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.login.SessionStoreTicketGrantingTicketAction;
import org.pac4j.core.context.session.SessionStore;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.web.servlet.View;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@Configuration(value="casOAuth20WebflowConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasOAuth20WebflowConfiguration {
    @Autowired
    @Qualifier(value="casProtocolViewFactory")
    private ObjectProvider<CasProtocolViewFactory> casProtocolViewFactory;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="loginFlowRegistry")
    private ObjectProvider<FlowDefinitionRegistry> loginFlowDefinitionRegistry;
    @Autowired
    @Qualifier(value="logoutFlowRegistry")
    private ObjectProvider<FlowDefinitionRegistry> logoutFlowDefinitionRegistry;
    @Autowired
    @Qualifier(value="oauth20AuthenticationRequestServiceSelectionStrategy")
    private ObjectProvider<AuthenticationServiceSelectionStrategy> oauth20AuthenticationServiceSelectionStrategy;
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private ObjectProvider<FlowBuilderServices> flowBuilderServices;
    @Autowired
    @Qualifier(value="oauthDistributedSessionStore")
    private ObjectProvider<SessionStore> oauthDistributedSessionStore;

    @ConditionalOnMissingBean(name={"oauth20LogoutWebflowConfigurer"})
    @Bean
    @DependsOn(value={"defaultWebflowConfigurer"})
    public CasWebflowConfigurer oauth20LogoutWebflowConfigurer() {
        OAuth20WebflowConfigurer c = new OAuth20WebflowConfigurer((FlowBuilderServices)this.flowBuilderServices.getObject(), (FlowDefinitionRegistry)this.loginFlowDefinitionRegistry.getObject(), this.applicationContext, this.casProperties);
        c.setLogoutFlowDefinitionRegistry((FlowDefinitionRegistry)this.logoutFlowDefinitionRegistry.getObject());
        return c;
    }

    @ConditionalOnMissingBean(name={"oauth20RegisteredServiceUIAction"})
    @Bean
    public Action oauth20RegisteredServiceUIAction() {
        return new OAuth20RegisteredServiceUIAction((ServicesManager)this.servicesManager.getObject(), (AuthenticationServiceSelectionStrategy)this.oauth20AuthenticationServiceSelectionStrategy.getObject());
    }

    @Bean
    @ConditionalOnMissingBean(name={"oauth20SessionStoreTicketGrantingTicketAction"})
    public Action oauth20SessionStoreTicketGrantingTicketAction() {
        return new SessionStoreTicketGrantingTicketAction((SessionStore)this.oauthDistributedSessionStore.getObject());
    }

    @Bean
    public View oauthConfirmView() {
        return ((CasProtocolViewFactory)this.casProtocolViewFactory.getObject()).create(this.applicationContext, "protocol/oauth/confirm");
    }

    @Bean
    public View oauthDeviceCodeApprovalView() {
        return ((CasProtocolViewFactory)this.casProtocolViewFactory.getObject()).create(this.applicationContext, "protocol/oauth/deviceCodeApproval");
    }

    @Bean
    public View oauthDeviceCodeApprovedView() {
        return ((CasProtocolViewFactory)this.casProtocolViewFactory.getObject()).create(this.applicationContext, "protocol/oauth/deviceCodeApproved");
    }

    @Bean
    public View oauthSessionStaleMismatchErrorView() {
        return ((CasProtocolViewFactory)this.casProtocolViewFactory.getObject()).create(this.applicationContext, "protocol/oauth/sessionStaleMismatchError");
    }

    @Bean
    @ConditionalOnMissingBean(name={"oauth20CasWebflowExecutionPlanConfigurer"})
    public CasWebflowExecutionPlanConfigurer oauth20CasWebflowExecutionPlanConfigurer() {
        return plan -> plan.registerWebflowConfigurer(this.oauth20LogoutWebflowConfigurer());
    }
}

