/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategy;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.web.flow.OAuth20RegisteredServiceUIAction;
import org.apereo.cas.support.oauth.web.flow.OAuth20WebflowConfigurer;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.validation.CasProtocolViewFactory;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.web.servlet.View;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.OAuth})
@AutoConfiguration
public class CasOAuth20WebflowConfiguration {

    @Configuration(value="CasOAuth20WebflowLogoutConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasOAuth20WebflowLogoutConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oauth20CasLogoutWebflowExecutionPlanConfigurer"})
        public CasWebflowExecutionPlanConfigurer oauth20CasLogoutWebflowExecutionPlanConfigurer(@Qualifier(value="oauth20LogoutWebflowConfigurer") CasWebflowConfigurer oauth20LogoutWebflowConfigurer) {
            return plan -> plan.registerWebflowConfigurer(oauth20LogoutWebflowConfigurer);
        }

        @ConditionalOnMissingBean(name={"oauth20LogoutWebflowConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowConfigurer oauth20LogoutWebflowConfigurer(@Qualifier(value="logoutFlowRegistry") FlowDefinitionRegistry logoutFlowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices, @Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry loginFlowDefinitionRegistry, CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            OAuth20WebflowConfigurer c = new OAuth20WebflowConfigurer(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
            c.setLogoutFlowDefinitionRegistry(logoutFlowDefinitionRegistry);
            return c;
        }
    }

    @Configuration(value="CasOAuth20ViewsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasOAuth20ViewsConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public View oauthConfirmView(@Qualifier(value="casProtocolThymeleafViewFactory") CasProtocolViewFactory casProtocolViewFactory, ConfigurableApplicationContext applicationContext) {
            return casProtocolViewFactory.create(applicationContext, "protocol/oauth/confirm");
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public View oauthDeviceCodeApprovalView(@Qualifier(value="casProtocolThymeleafViewFactory") CasProtocolViewFactory casProtocolViewFactory, ConfigurableApplicationContext applicationContext) {
            return casProtocolViewFactory.create(applicationContext, "protocol/oauth/deviceCodeApproval");
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public View oauthDeviceCodeApprovedView(@Qualifier(value="casProtocolThymeleafViewFactory") CasProtocolViewFactory casProtocolViewFactory, ConfigurableApplicationContext applicationContext) {
            return casProtocolViewFactory.create(applicationContext, "protocol/oauth/deviceCodeApproved");
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public View oauthSessionStaleMismatchErrorView(@Qualifier(value="casProtocolThymeleafViewFactory") CasProtocolViewFactory casProtocolViewFactory, ConfigurableApplicationContext applicationContext) {
            return casProtocolViewFactory.create(applicationContext, "protocol/oauth/sessionStaleMismatchError");
        }
    }

    @Configuration(value="CasOAuth20WebflowActionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasOAuth20WebflowActionConfiguration {
        @ConditionalOnMissingBean(name={"oauth20RegisteredServiceUIAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action oauth20RegisteredServiceUIAction(@Qualifier(value="oauth20AuthenticationRequestServiceSelectionStrategy") AuthenticationServiceSelectionStrategy oauth20AuthenticationServiceSelectionStrategy, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new OAuth20RegisteredServiceUIAction(servicesManager, oauth20AuthenticationServiceSelectionStrategy);
        }
    }
}

