/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.validator.authorization;

import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20AuthorizationRequestValidator;
import org.apereo.cas.util.HttpRequestUtils;
import org.pac4j.core.context.J2EContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20AuthorizationCodeResponseTypeAuthorizationRequestValidator
implements OAuth20AuthorizationRequestValidator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20AuthorizationCodeResponseTypeAuthorizationRequestValidator.class);
    private final ServicesManager servicesManager;
    private final ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory;
    private final AuditableExecution registeredServiceAccessStrategyEnforcer;

    @Override
    public boolean validate(J2EContext context) {
        boolean checkParameterExist;
        HttpServletRequest request = context.getRequest();
        boolean bl = checkParameterExist = HttpRequestUtils.doesParameterExist((HttpServletRequest)request, (String)"client_id") && HttpRequestUtils.doesParameterExist((HttpServletRequest)request, (String)"redirect_uri") && HttpRequestUtils.doesParameterExist((HttpServletRequest)request, (String)"response_type");
        if (!checkParameterExist) {
            LOGGER.warn("Missing required parameters (client id, redirect uri, etc) for response type [{}].", (Object)this.getResponseType());
            return false;
        }
        String responseType = request.getParameter("response_type");
        if (!OAuth20Utils.checkResponseTypes(responseType, OAuth20ResponseTypes.values())) {
            LOGGER.warn("Response type [{}] is not supported.", (Object)responseType);
            return false;
        }
        String clientId = request.getParameter("client_id");
        OAuthRegisteredService registeredService = this.getRegisteredServiceByClientId(clientId);
        WebApplicationService service = (WebApplicationService)this.webApplicationServiceServiceFactory.createService(registeredService.getServiceId());
        AuditableContext audit = AuditableContext.builder().service((Service)service).registeredService((RegisteredService)registeredService).build();
        AuditableExecutionResult accessResult = this.registeredServiceAccessStrategyEnforcer.execute(audit);
        if (accessResult.isExecutionFailure()) {
            LOGGER.warn("Registered service [{}] is not found or is not authorized for access.", (Object)registeredService);
            return false;
        }
        String redirectUri = request.getParameter("redirect_uri");
        if (!OAuth20Utils.checkCallbackValid((RegisteredService)registeredService, redirectUri)) {
            LOGGER.warn("Callback URL [{}] is not authorized for registered service [{}].", (Object)redirectUri, (Object)registeredService);
            return false;
        }
        return OAuth20Utils.isAuthorizedResponseTypeForService(context, registeredService);
    }

    protected OAuthRegisteredService getRegisteredServiceByClientId(String clientId) {
        return OAuth20Utils.getRegisteredOAuthServiceByClientId(this.servicesManager, clientId);
    }

    @Override
    public boolean supports(J2EContext context) {
        String grantType = context.getRequestParameter("response_type");
        return OAuth20Utils.isResponseType(grantType, this.getResponseType());
    }

    public OAuth20ResponseTypes getResponseType() {
        return OAuth20ResponseTypes.CODE;
    }

    @Generated
    public OAuth20AuthorizationCodeResponseTypeAuthorizationRequestValidator(ServicesManager servicesManager, ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory, AuditableExecution registeredServiceAccessStrategyEnforcer) {
        this.servicesManager = servicesManager;
        this.webApplicationServiceServiceFactory = webApplicationServiceServiceFactory;
        this.registeredServiceAccessStrategyEnforcer = registeredServiceAccessStrategyEnforcer;
    }
}

