/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.validator.token;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.token.OAuth20TokenRequestValidator;
import org.apereo.cas.util.Pac4jUtils;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseOAuth20TokenRequestValidator
implements OAuth20TokenRequestValidator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseOAuth20TokenRequestValidator.class);
    protected final AuditableExecution registeredServiceAccessStrategyEnforcer;
    protected final ServicesManager servicesManager;
    protected final ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory;
    private int order = Integer.MAX_VALUE;

    private static boolean isGrantTypeSupported(String type, OAuth20GrantTypes ... expectedTypes) {
        LOGGER.debug("Grant type received: [{}]", (Object)type);
        for (OAuth20GrantTypes expectedType : expectedTypes) {
            if (!OAuth20Utils.isGrantType(type, expectedType)) continue;
            return true;
        }
        LOGGER.error("Unsupported grant type: [{}]", (Object)type);
        return false;
    }

    protected boolean isGrantTypeSupportedBy(OAuthRegisteredService registeredService, OAuth20GrantTypes type) {
        return this.isGrantTypeSupportedBy(registeredService, type.getType());
    }

    protected boolean isGrantTypeSupportedBy(OAuthRegisteredService registeredService, String type) {
        return OAuth20Utils.isAuthorizedGrantTypeForService(type, registeredService);
    }

    @Override
    public boolean validate(J2EContext context) {
        HttpServletRequest request = context.getRequest();
        HttpServletResponse response = context.getResponse();
        String grantType = request.getParameter("grant_type");
        if (!BaseOAuth20TokenRequestValidator.isGrantTypeSupported(grantType, OAuth20GrantTypes.values())) {
            LOGGER.warn("Grant type is not supported: [{}]", (Object)grantType);
            return false;
        }
        ProfileManager manager = Pac4jUtils.getPac4jProfileManager((HttpServletRequest)request, (HttpServletResponse)response);
        Optional profile = manager.get(true);
        if (profile == null || !profile.isPresent()) {
            LOGGER.warn("Could not locate authenticated profile for this request. Request is not authenticated");
            return false;
        }
        CommonProfile uProfile = (CommonProfile)profile.get();
        if (uProfile == null) {
            LOGGER.warn("Could not locate authenticated profile for this request as null");
            return false;
        }
        return this.validateInternal(context, grantType, manager, (UserProfile)uProfile);
    }

    protected boolean validateInternal(J2EContext context, String grantType, ProfileManager manager, UserProfile userProfile) {
        return false;
    }

    protected abstract OAuth20GrantTypes getGrantType();

    @Override
    public boolean supports(J2EContext context) {
        String grantType = context.getRequestParameter("grant_type");
        return OAuth20Utils.isGrantType(grantType, this.getGrantType());
    }

    @Generated
    public BaseOAuth20TokenRequestValidator(AuditableExecution registeredServiceAccessStrategyEnforcer, ServicesManager servicesManager, ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory) {
        this.registeredServiceAccessStrategyEnforcer = registeredServiceAccessStrategyEnforcer;
        this.servicesManager = servicesManager;
        this.webApplicationServiceServiceFactory = webApplicationServiceServiceFactory;
    }

    @Generated
    public AuditableExecution getRegisteredServiceAccessStrategyEnforcer() {
        return this.registeredServiceAccessStrategyEnforcer;
    }

    @Generated
    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    @Generated
    public ServiceFactory<WebApplicationService> getWebApplicationServiceServiceFactory() {
        return this.webApplicationServiceServiceFactory;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }
}

