/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Collection;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.support.oauth.web.OAuth20HandlerInterceptorAdapter;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenGrantRequestExtractor;
import org.apereo.cas.throttle.AuthenticationThrottlingExecutionPlan;
import org.apereo.cas.throttle.AuthenticationThrottlingExecutionPlanConfigurer;
import org.pac4j.core.config.Config;
import org.pac4j.springframework.web.SecurityInterceptor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Configuration(value="oauthThrottleConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasOAuthThrottleConfiguration
implements AuthenticationThrottlingExecutionPlanConfigurer {
    @Autowired
    @Qualifier(value="oauthSecConfig")
    private ObjectProvider<Config> oauthSecConfig;
    @Autowired
    @Qualifier(value="accessTokenGrantRequestExtractors")
    private Collection<AccessTokenGrantRequestExtractor> accessTokenGrantRequestExtractors;

    @ConditionalOnMissingBean(name={"requiresAuthenticationAuthorizeInterceptor"})
    @Bean
    public SecurityInterceptor requiresAuthenticationAuthorizeInterceptor() {
        return new SecurityInterceptor((Config)this.oauthSecConfig.getIfAvailable(), "CasOAuthClient");
    }

    @ConditionalOnMissingBean(name={"requiresAuthenticationAccessTokenInterceptor"})
    @Bean
    public SecurityInterceptor requiresAuthenticationAccessTokenInterceptor() {
        String clients = String.join((CharSequence)",", "clientBasicAuth", "userForm", "clientForm", "pkceAuthn");
        return new SecurityInterceptor((Config)this.oauthSecConfig.getIfAvailable(), clients);
    }

    @ConditionalOnMissingBean(name={"oauthHandlerInterceptorAdapter"})
    @Bean
    public HandlerInterceptor oauthHandlerInterceptorAdapter() {
        return new OAuth20HandlerInterceptorAdapter((HandlerInterceptorAdapter)this.requiresAuthenticationAccessTokenInterceptor(), (HandlerInterceptorAdapter)this.requiresAuthenticationAuthorizeInterceptor(), this.accessTokenGrantRequestExtractors);
    }

    public void configureAuthenticationThrottlingExecutionPlan(AuthenticationThrottlingExecutionPlan plan) {
        plan.registerAuthenticationThrottleInterceptor(this.oauthHandlerInterceptorAdapter());
    }

    @Configuration(value="oauthThrottleWebMvcConfigurer")
    static class CasOAuthThrottleWebMvcConfigurer
    implements WebMvcConfigurer {
        @Autowired
        @Qualifier(value="authenticationThrottlingExecutionPlan")
        private ObjectProvider<AuthenticationThrottlingExecutionPlan> authenticationThrottlingExecutionPlan;

        CasOAuthThrottleWebMvcConfigurer() {
        }

        public void addInterceptors(InterceptorRegistry registry) {
            ((AuthenticationThrottlingExecutionPlan)this.authenticationThrottlingExecutionPlan.getIfAvailable()).getAuthenticationThrottleInterceptors().forEach(handler -> {
                String baseUrl = "/oauth2.0".concat("/");
                registry.addInterceptor(handler).addPathPatterns(new String[]{baseUrl.concat("authorize").concat("*")}).addPathPatterns(new String[]{baseUrl.concat("accessToken").concat("*")}).addPathPatterns(new String[]{baseUrl.concat("introspect").concat("*")}).addPathPatterns(new String[]{baseUrl.concat("callbackAuthorize").concat("*")}).addPathPatterns(new String[]{baseUrl.concat("device").concat("*")}).addPathPatterns(new String[]{baseUrl.concat("token").concat("*")}).addPathPatterns(new String[]{baseUrl.concat("profile").concat("*")});
            });
        }
    }
}

