/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.authenticator;

import lombok.Generated;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.profile.CommonProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20ClientIdClientSecretAuthenticator
implements Authenticator<UsernamePasswordCredentials> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20ClientIdClientSecretAuthenticator.class);
    private final ServicesManager servicesManager;
    private final ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory;
    private final AuditableExecution registeredServiceAccessStrategyEnforcer;

    public void validate(UsernamePasswordCredentials credentials, WebContext context) throws CredentialsException {
        LOGGER.debug("Authenticating credential [{}]", (Object)credentials);
        String id = credentials.getUsername();
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)this.servicesManager, (String)id);
        if (registeredService == null) {
            throw new CredentialsException("Unable to locate registered service for " + id);
        }
        WebApplicationService service = (WebApplicationService)this.webApplicationServiceServiceFactory.createService(registeredService.getServiceId());
        AuditableContext audit = AuditableContext.builder().service((Service)service).registeredService((RegisteredService)registeredService).build();
        AuditableExecutionResult accessResult = this.registeredServiceAccessStrategyEnforcer.execute(audit);
        accessResult.throwExceptionIfNeeded();
        this.validateCredentials(credentials, registeredService, context);
        CommonProfile profile = new CommonProfile();
        profile.setId(id);
        credentials.setUserProfile(profile);
        LOGGER.debug("Authenticated user profile [{}]", (Object)profile);
    }

    protected void validateCredentials(UsernamePasswordCredentials credentials, OAuthRegisteredService registeredService, WebContext context) {
        if (!OAuth20Utils.checkClientSecret((OAuthRegisteredService)registeredService, (String)credentials.getPassword())) {
            throw new CredentialsException("Bad secret for client identifier: " + credentials.getPassword());
        }
    }

    @Generated
    public OAuth20ClientIdClientSecretAuthenticator(ServicesManager servicesManager, ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory, AuditableExecution registeredServiceAccessStrategyEnforcer) {
        this.servicesManager = servicesManager;
        this.webApplicationServiceServiceFactory = webApplicationServiceServiceFactory;
        this.registeredServiceAccessStrategyEnforcer = registeredServiceAccessStrategyEnforcer;
    }
}

