/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.authenticator;

import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.authenticator.OAuth20ClientIdClientSecretAuthenticator;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.ticket.code.OAuthCode;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.util.EncodingUtils;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.exception.CredentialsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20ProofKeyCodeExchangeAuthenticator
extends OAuth20ClientIdClientSecretAuthenticator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20ProofKeyCodeExchangeAuthenticator.class);
    private final TicketRegistry ticketRegistry;

    public OAuth20ProofKeyCodeExchangeAuthenticator(ServicesManager servicesManager, ServiceFactory webApplicationServiceFactory, AuditableExecution registeredServiceAccessStrategyEnforcer, TicketRegistry ticketRegistry) {
        super(servicesManager, (ServiceFactory<WebApplicationService>)webApplicationServiceFactory, registeredServiceAccessStrategyEnforcer);
        this.ticketRegistry = ticketRegistry;
    }

    @Override
    protected void validateCredentials(UsernamePasswordCredentials credentials, OAuthRegisteredService registeredService, WebContext context) {
        String codeVerifier = credentials.getPassword();
        String code = context.getRequestParameter("code");
        OAuthCode token = (OAuthCode)this.ticketRegistry.getTicket(code, OAuthCode.class);
        if (token == null || token.isExpired()) {
            LOGGER.error("Provided code [{}] is either not found in the ticket registry or has expired", (Object)code);
            throw new CredentialsException("Invalid token: " + code);
        }
        String method = StringUtils.defaultString((String)token.getCodeChallengeMethod(), (String)"plain");
        String hash = OAuth20ProofKeyCodeExchangeAuthenticator.calculateCodeVerifierHash(method, codeVerifier);
        if (!hash.equalsIgnoreCase(token.getCodeChallenge())) {
            LOGGER.error("Code verifier [{}] does not match the challenge [{}]", (Object)hash, (Object)token.getCodeChallenge());
            throw new CredentialsException("Code verification does not match the challenge assigned to: " + token.getId());
        }
        LOGGER.debug("Validated code verifier using verification method [{}]", (Object)method);
    }

    private static String calculateCodeVerifierHash(String method, String codeVerifier) {
        if ("plain".equalsIgnoreCase(method)) {
            return codeVerifier;
        }
        if ("S256".equalsIgnoreCase(method)) {
            String sha256 = DigestUtils.sha256((String)codeVerifier);
            return EncodingUtils.encodeUrlSafeBase64((byte[])sha256.getBytes(StandardCharsets.UTF_8));
        }
        throw new CredentialsException("Code verification method is unrecognized: " + method);
    }
}

