/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.authenticator;

import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.credentials.extractor.BasicAuthExtractor;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.profile.CommonProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20UsernamePasswordAuthenticator
implements Authenticator<UsernamePasswordCredentials> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20UsernamePasswordAuthenticator.class);
    private final AuthenticationSystemSupport authenticationSystemSupport;
    private final ServicesManager servicesManager;
    private final ServiceFactory webApplicationServiceFactory;

    public void validate(UsernamePasswordCredentials credentials, WebContext context) throws CredentialsException {
        UsernamePasswordCredential casCredential = new UsernamePasswordCredential(credentials.getUsername(), credentials.getPassword());
        try {
            Pair<String, String> clientIdAndSecret = this.getClientIdAndClientSecret(context);
            if (clientIdAndSecret == null || StringUtils.isBlank((CharSequence)((CharSequence)clientIdAndSecret.getKey()))) {
                throw new CredentialsException("No client credentials could be identified in this request");
            }
            String clientId = (String)clientIdAndSecret.getKey();
            OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)this.servicesManager, (String)clientId);
            RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((RegisteredService)registeredService);
            String clientSecret = (String)clientIdAndSecret.getRight();
            if (StringUtils.isNotBlank((CharSequence)clientSecret) && !OAuth20Utils.checkClientSecret((OAuthRegisteredService)registeredService, (String)clientSecret)) {
                throw new CredentialsException("Bad secret for client identifier: " + clientId);
            }
            String redirectUri = context.getRequestParameter("redirect_uri");
            Service service = StringUtils.isNotBlank((CharSequence)redirectUri) ? this.webApplicationServiceFactory.createService(redirectUri) : null;
            AuthenticationResult authenticationResult = this.authenticationSystemSupport.handleAndFinalizeSingleAuthenticationTransaction(service, new Credential[]{casCredential});
            if (authenticationResult == null) {
                throw new CredentialsException("Could not authenticate the provided credentials");
            }
            Authentication authentication = authenticationResult.getAuthentication();
            Principal principal = authentication.getPrincipal();
            Map attributes = registeredService.getAttributeReleasePolicy().getAttributes(principal, service, (RegisteredService)registeredService);
            CommonProfile profile = new CommonProfile();
            String id = registeredService.getUsernameAttributeProvider().resolveUsername(principal, service, (RegisteredService)registeredService);
            LOGGER.debug("Created profile id [{}]", (Object)id);
            profile.setId(id);
            profile.addAttributes(attributes);
            LOGGER.debug("Authenticated user profile [{}]", (Object)profile);
            credentials.setUserProfile(profile);
        }
        catch (Exception e) {
            throw new CredentialsException("Cannot login user using CAS internal authentication", (Throwable)e);
        }
    }

    protected Pair<String, String> getClientIdAndClientSecret(WebContext context) {
        BasicAuthExtractor extractor = new BasicAuthExtractor();
        UsernamePasswordCredentials upc = extractor.extract(context);
        if (upc != null) {
            return Pair.of((Object)upc.getUsername(), (Object)upc.getPassword());
        }
        String clientId = context.getRequestParameter("client_id");
        String clientSecret = context.getRequestParameter("client_secret");
        return Pair.of((Object)clientId, (Object)clientSecret);
    }

    @Generated
    public OAuth20UsernamePasswordAuthenticator(AuthenticationSystemSupport authenticationSystemSupport, ServicesManager servicesManager, ServiceFactory webApplicationServiceFactory) {
        this.authenticationSystemSupport = authenticationSystemSupport;
        this.servicesManager = servicesManager;
        this.webApplicationServiceFactory = webApplicationServiceFactory;
    }
}

