/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.profile;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.profile.OAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.profile.OAuth20UserProfileDataCreator;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.ticket.accesstoken.AccessToken;
import org.apereo.inspektr.audit.annotation.Audit;
import org.pac4j.core.context.J2EContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOAuth20UserProfileDataCreator
implements OAuth20UserProfileDataCreator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultOAuth20UserProfileDataCreator.class);
    private final ServicesManager servicesManager;
    private final OAuth20ProfileScopeToAttributesFilter scopeToAttributesFilter;

    @Override
    @Audit(action="OAUTH2_USER_PROFILE_DATA", actionResolverName="OAUTH2_USER_PROFILE_DATA_ACTION_RESOLVER", resourceResolverName="OAUTH2_USER_PROFILE_DATA_RESOURCE_RESOLVER")
    public Map<String, Object> createFrom(AccessToken accessToken, J2EContext context) {
        Service service = accessToken.getService();
        RegisteredService registeredService = this.servicesManager.findServiceBy(service);
        Principal principal = this.getAccessTokenAuthenticationPrincipal(accessToken, context, registeredService);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", principal.getId());
        Map attributes = principal.getAttributes();
        map.put("attributes", attributes);
        this.finalizeProfileResponse(accessToken, map, principal);
        return map;
    }

    protected Principal getAccessTokenAuthenticationPrincipal(AccessToken accessToken, J2EContext context, RegisteredService registeredService) {
        Principal currentPrincipal = accessToken.getAuthentication().getPrincipal();
        LOGGER.debug("Preparing user profile response based on CAS principal [{}]", (Object)currentPrincipal);
        Principal principal = this.scopeToAttributesFilter.filter(accessToken.getService(), currentPrincipal, registeredService, context, accessToken);
        LOGGER.debug("Created CAS principal [{}] based on requested/authorized scopes", (Object)principal);
        return principal;
    }

    protected void finalizeProfileResponse(AccessToken accessTokenTicket, Map<String, Object> map, Principal principal) {
        Service service = accessTokenTicket.getService();
        RegisteredService registeredService = this.servicesManager.findServiceBy(service);
        if (registeredService instanceof OAuthRegisteredService) {
            OAuthRegisteredService oauth = (OAuthRegisteredService)registeredService;
            map.put("client_id", oauth.getClientId());
            map.put("service", service.getId());
        }
    }

    @Generated
    public DefaultOAuth20UserProfileDataCreator(ServicesManager servicesManager, OAuth20ProfileScopeToAttributesFilter scopeToAttributesFilter) {
        this.servicesManager = servicesManager;
        this.scopeToAttributesFilter = scopeToAttributesFilter;
    }
}

