/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.services;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.util.HttpRequestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20AuthenticationServiceSelectionStrategy
implements AuthenticationServiceSelectionStrategy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20AuthenticationServiceSelectionStrategy.class);
    private static final long serialVersionUID = 8517547235465666978L;
    private final transient ServicesManager servicesManager;
    private final transient ServiceFactory<WebApplicationService> webApplicationServiceFactory;
    private final String callbackUrl;
    private final int order = Integer.MIN_VALUE;

    private static Optional<NameValuePair> resolveClientIdFromService(Service service) {
        try {
            URIBuilder builder = new URIBuilder(service.getId());
            return builder.getQueryParams().stream().filter(p -> p.getName().equals("client_id")).findFirst();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return Optional.empty();
        }
    }

    private static Optional<NameValuePair> resolveRedirectUri(Service service) {
        try {
            URIBuilder builder = new URIBuilder(service.getId());
            return builder.getQueryParams().stream().filter(p -> p.getName().equals("redirect_uri")).findFirst();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return Optional.empty();
        }
    }

    private static Optional<NameValuePair> resolveGrantType(Service service) {
        try {
            URIBuilder builder = new URIBuilder(service.getId());
            return builder.getQueryParams().stream().filter(p -> p.getName().equals("grant_type")).findFirst();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return Optional.empty();
        }
    }

    public Service resolveServiceFrom(Service service) {
        Optional<NameValuePair> clientId = OAuth20AuthenticationServiceSelectionStrategy.resolveClientIdFromService(service);
        Optional<NameValuePair> redirectUri = OAuth20AuthenticationServiceSelectionStrategy.resolveRedirectUri(service);
        Optional<NameValuePair> grantType = OAuth20AuthenticationServiceSelectionStrategy.resolveGrantType(service);
        if (clientId.isPresent()) {
            if (redirectUri.isPresent()) {
                return this.webApplicationServiceFactory.createService(redirectUri.get().getValue());
            }
            if (grantType.isPresent()) {
                String id = "";
                String grantValue = grantType.get().getValue();
                if (OAuth20Utils.isGrantType((String)grantValue, (OAuth20GrantTypes)OAuth20GrantTypes.CLIENT_CREDENTIALS)) {
                    LOGGER.debug("Located grant type [{}]; checking for service headers", (Object)grantValue);
                    HttpServletRequest request = HttpRequestUtils.getHttpServletRequestFromRequestAttributes();
                    id = OAuth20Utils.getServiceRequestHeaderIfAny((HttpServletRequest)request);
                }
                if (StringUtils.isBlank((CharSequence)id)) {
                    id = clientId.get().getValue();
                }
                LOGGER.debug("Built web application service based on identifier [{}]", (Object)id);
                return this.webApplicationServiceFactory.createService(id);
            }
        }
        return service;
    }

    public boolean supports(Service service) {
        RegisteredService svc = this.servicesManager.findServiceBy(service);
        boolean res = svc != null && service.getId().startsWith(this.callbackUrl);
        LOGGER.trace("Authentication request is{} identified as an OAuth request", (Object)BooleanUtils.toString((boolean)res, (String)"", (String)" not"));
        return res;
    }

    @Generated
    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    @Generated
    public ServiceFactory<WebApplicationService> getWebApplicationServiceFactory() {
        return this.webApplicationServiceFactory;
    }

    @Generated
    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public OAuth20AuthenticationServiceSelectionStrategy(ServicesManager servicesManager, ServiceFactory<WebApplicationService> webApplicationServiceFactory, String callbackUrl) {
        this.servicesManager = servicesManager;
        this.webApplicationServiceFactory = webApplicationServiceFactory;
        this.callbackUrl = callbackUrl;
    }
}

