/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.validator.authorization;

import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20AuthorizationRequestValidator;
import org.apereo.cas.util.HttpRequestUtils;
import org.pac4j.core.context.J2EContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20AuthorizationCodeResponseTypeAuthorizationRequestValidator
implements OAuth20AuthorizationRequestValidator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20AuthorizationCodeResponseTypeAuthorizationRequestValidator.class);
    protected final ServicesManager servicesManager;
    protected final ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory;
    protected final AuditableExecution registeredServiceAccessStrategyEnforcer;
    private int order = Integer.MAX_VALUE;

    @Override
    public boolean validate(J2EContext context) {
        HttpServletRequest request = context.getRequest();
        boolean checkParameterExist = Stream.of("client_id", "redirect_uri", "response_type").allMatch(s -> HttpRequestUtils.doesParameterExist((HttpServletRequest)request, (String)s));
        if (!checkParameterExist) {
            LOGGER.warn("Missing required parameters (client id, redirect uri, etc) for response type [{}].", (Object)this.getResponseType());
            return false;
        }
        String responseType = request.getParameter("response_type");
        if (!OAuth20Utils.checkResponseTypes((String)responseType, (OAuth20ResponseTypes[])OAuth20ResponseTypes.values())) {
            LOGGER.warn("Response type [{}] is not supported.", (Object)responseType);
            return false;
        }
        String clientId = request.getParameter("client_id");
        OAuthRegisteredService registeredService = this.getRegisteredServiceByClientId(clientId);
        WebApplicationService service = registeredService != null ? (WebApplicationService)this.webApplicationServiceServiceFactory.createService(registeredService.getServiceId()) : null;
        AuditableContext audit = AuditableContext.builder().service(service).registeredService((RegisteredService)registeredService).build();
        AuditableExecutionResult accessResult = this.registeredServiceAccessStrategyEnforcer.execute(audit);
        if (accessResult.isExecutionFailure()) {
            LOGGER.warn("Registered service [{}] is not found or is not authorized for access.", (Object)registeredService);
            return false;
        }
        String redirectUri = request.getParameter("redirect_uri");
        if (!OAuth20Utils.checkCallbackValid((RegisteredService)registeredService, (String)redirectUri)) {
            LOGGER.warn("Callback URL [{}] is not authorized for registered service [{}].", (Object)redirectUri, (Object)registeredService);
            return false;
        }
        return OAuth20Utils.isAuthorizedResponseTypeForService((J2EContext)context, (OAuthRegisteredService)registeredService);
    }

    protected OAuthRegisteredService getRegisteredServiceByClientId(String clientId) {
        return OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)this.servicesManager, (String)clientId);
    }

    @Override
    public boolean supports(J2EContext context) {
        String grantType = context.getRequestParameter("response_type");
        return OAuth20Utils.isResponseType((String)grantType, (OAuth20ResponseTypes)this.getResponseType());
    }

    public OAuth20ResponseTypes getResponseType() {
        return OAuth20ResponseTypes.CODE;
    }

    @Generated
    public OAuth20AuthorizationCodeResponseTypeAuthorizationRequestValidator(ServicesManager servicesManager, ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory, AuditableExecution registeredServiceAccessStrategyEnforcer) {
        this.servicesManager = servicesManager;
        this.webApplicationServiceServiceFactory = webApplicationServiceServiceFactory;
        this.registeredServiceAccessStrategyEnforcer = registeredServiceAccessStrategyEnforcer;
    }

    @Generated
    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    @Generated
    public ServiceFactory<WebApplicationService> getWebApplicationServiceServiceFactory() {
        return this.webApplicationServiceServiceFactory;
    }

    @Generated
    public AuditableExecution getRegisteredServiceAccessStrategyEnforcer() {
        return this.registeredServiceAccessStrategyEnforcer;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }
}

