/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.validator.token;

import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.token.OAuth20TokenRequestValidator;
import org.pac4j.core.context.J2EContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20DeviceCodeResponseTypeRequestValidator
implements OAuth20TokenRequestValidator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20DeviceCodeResponseTypeRequestValidator.class);
    private final ServicesManager servicesManager;
    private final ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory;
    private int order = Integer.MAX_VALUE;

    @Override
    public boolean validate(J2EContext context) {
        HttpServletRequest request = context.getRequest();
        String responseType = request.getParameter("response_type");
        if (!OAuth20Utils.checkResponseTypes((String)responseType, (OAuth20ResponseTypes[])OAuth20ResponseTypes.values())) {
            LOGGER.warn("Response type [{}] is not supported.", (Object)responseType);
            return false;
        }
        String clientId = request.getParameter("client_id");
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)this.servicesManager, (String)clientId);
        try {
            RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((RegisteredService)registeredService);
        }
        catch (UnauthorizedServiceException e) {
            LOGGER.warn("Registered service access is not allowed for service definition for client id [{}]", (Object)clientId);
            return false;
        }
        return OAuth20Utils.isAuthorizedResponseTypeForService((J2EContext)context, (OAuthRegisteredService)registeredService);
    }

    @Override
    public boolean supports(J2EContext context) {
        String responseType = context.getRequestParameter("response_type");
        String clientId = context.getRequestParameter("client_id");
        return OAuth20Utils.isResponseType((String)responseType, (OAuth20ResponseTypes)OAuth20ResponseTypes.DEVICE_CODE) && StringUtils.isNotBlank((CharSequence)clientId);
    }

    @Generated
    public OAuth20DeviceCodeResponseTypeRequestValidator(ServicesManager servicesManager, ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory) {
        this.servicesManager = servicesManager;
        this.webApplicationServiceServiceFactory = webApplicationServiceServiceFactory;
    }

    @Generated
    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    @Generated
    public ServiceFactory<WebApplicationService> getWebApplicationServiceServiceFactory() {
        return this.webApplicationServiceServiceFactory;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }
}

