/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web;

import java.util.Optional;
import lombok.Generated;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.http.url.UrlResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20CasCallbackUrlResolver
implements UrlResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20CasCallbackUrlResolver.class);
    private final String callbackUrl;

    private static Optional<NameValuePair> getQueryParameter(WebContext context, String name) {
        URIBuilder builderContext = new URIBuilder(context.getFullRequestURL());
        return builderContext.getQueryParams().stream().filter(p -> p.getName().equalsIgnoreCase(name)).findFirst();
    }

    public String compute(String url, WebContext context) {
        if (url.startsWith(this.callbackUrl)) {
            URIBuilder builder = new URIBuilder(url);
            Optional<NameValuePair> parameter = OAuth20CasCallbackUrlResolver.getQueryParameter(context, "client_id");
            parameter.ifPresent(basicNameValuePair -> builder.addParameter(basicNameValuePair.getName(), basicNameValuePair.getValue()));
            parameter = OAuth20CasCallbackUrlResolver.getQueryParameter(context, "redirect_uri");
            parameter.ifPresent(basicNameValuePair -> builder.addParameter(basicNameValuePair.getName(), basicNameValuePair.getValue()));
            parameter = OAuth20CasCallbackUrlResolver.getQueryParameter(context, "acr_values");
            parameter.ifPresent(basicNameValuePair -> builder.addParameter(basicNameValuePair.getName(), basicNameValuePair.getValue()));
            parameter = OAuth20CasCallbackUrlResolver.getQueryParameter(context, "response_type");
            parameter.ifPresent(basicNameValuePair -> builder.addParameter(basicNameValuePair.getName(), basicNameValuePair.getValue()));
            parameter = OAuth20CasCallbackUrlResolver.getQueryParameter(context, "grant_type");
            parameter.ifPresent(basicNameValuePair -> builder.addParameter(basicNameValuePair.getName(), basicNameValuePair.getValue()));
            String callbackResolved = builder.build().toString();
            LOGGER.debug("Final resolved callback URL is [{}]", (Object)callbackResolved);
            return callbackResolved;
        }
        return url;
    }

    @Generated
    public OAuth20CasCallbackUrlResolver(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }
}

