/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web;

import java.util.Collection;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenGrantRequestExtractor;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class OAuth20HandlerInterceptorAdapter
extends HandlerInterceptorAdapter {
    protected final HandlerInterceptorAdapter requiresAuthenticationAccessTokenInterceptor;
    protected final HandlerInterceptorAdapter requiresAuthenticationAuthorizeInterceptor;
    private final Collection<AccessTokenGrantRequestExtractor> accessTokenGrantRequestExtractors;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (this.requestRequiresAuthentication(request, response)) {
            return this.requiresAuthenticationAccessTokenInterceptor.preHandle(request, response, handler);
        }
        if (this.isDeviceTokenRequest(request, response)) {
            return this.requiresAuthenticationAuthorizeInterceptor.preHandle(request, response, handler);
        }
        if (this.isAuthorizationRequest(request, response)) {
            return this.requiresAuthenticationAuthorizeInterceptor.preHandle(request, response, handler);
        }
        return true;
    }

    protected boolean isAccessTokenRequest(HttpServletRequest request, HttpServletResponse response) {
        String requestPath = request.getRequestURI();
        String pattern = String.format("(%s|%s)", "accessToken", "token");
        return this.doesUriMatchPattern(requestPath, pattern);
    }

    protected boolean isDeviceTokenRequest(HttpServletRequest request, HttpServletResponse response) {
        String requestPath = request.getRequestURI();
        String pattern = String.format("(%s)", "device");
        return this.doesUriMatchPattern(requestPath, pattern);
    }

    protected boolean requestRequiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        boolean accessTokenRequest = this.isAccessTokenRequest(request, response);
        if (!accessTokenRequest) {
            Optional<AccessTokenGrantRequestExtractor> extractor = this.extractAccessTokenGrantRequest(request);
            if (extractor.isPresent()) {
                AccessTokenGrantRequestExtractor ext = extractor.get();
                return ext.requestMustBeAuthenticated();
            }
        } else {
            Optional<AccessTokenGrantRequestExtractor> extractor = this.extractAccessTokenGrantRequest(request);
            if (extractor.isPresent()) {
                AccessTokenGrantRequestExtractor ext = extractor.get();
                return ext.getResponseType() != OAuth20ResponseTypes.DEVICE_CODE;
            }
        }
        return false;
    }

    private Optional<AccessTokenGrantRequestExtractor> extractAccessTokenGrantRequest(HttpServletRequest request) {
        return this.accessTokenGrantRequestExtractors.stream().filter(ext -> ext.supports(request)).findFirst();
    }

    protected boolean isAuthorizationRequest(HttpServletRequest request, HttpServletResponse response) {
        String requestPath = request.getRequestURI();
        return this.doesUriMatchPattern(requestPath, "authorize");
    }

    protected boolean doesUriMatchPattern(String requestPath, String patternUrl) {
        Pattern pattern = Pattern.compile("/" + patternUrl + "(/)*$");
        return pattern.matcher(requestPath).find();
    }

    @Generated
    public OAuth20HandlerInterceptorAdapter(HandlerInterceptorAdapter requiresAuthenticationAccessTokenInterceptor, HandlerInterceptorAdapter requiresAuthenticationAuthorizeInterceptor, Collection<AccessTokenGrantRequestExtractor> accessTokenGrantRequestExtractors) {
        this.requiresAuthenticationAccessTokenInterceptor = requiresAuthenticationAccessTokenInterceptor;
        this.requiresAuthenticationAuthorizeInterceptor = requiresAuthenticationAuthorizeInterceptor;
        this.accessTokenGrantRequestExtractors = accessTokenGrantRequestExtractors;
    }
}

