/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.audit;

import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestDataHolder;
import org.apereo.inspektr.audit.spi.support.ReturnValueAsStringResourceResolver;
import org.aspectj.lang.JoinPoint;

public class AccessTokenGrantRequestAuditResourceResolver
extends ReturnValueAsStringResourceResolver {
    public String[] resolveFrom(JoinPoint auditableTarget, Object retval) {
        AuditableExecutionResult auditResult = (AuditableExecutionResult)retval;
        Optional executionResult = auditResult.getExecutionResult();
        if (executionResult.isPresent()) {
            AccessTokenRequestDataHolder accessTokenRequest = (AccessTokenRequestDataHolder)executionResult.get();
            String tokenId = accessTokenRequest.getToken() == null ? "N/A" : accessTokenRequest.getToken().getId();
            String result = new ToStringBuilder((Object)this, ToStringStyle.NO_CLASS_NAME_STYLE).append("token", (Object)tokenId).append("client_id", (Object)accessTokenRequest.getRegisteredService().getClientId()).append("service", (Object)accessTokenRequest.getService().getId()).append("grant_type", (Object)accessTokenRequest.getGrantType().getType()).append("response_type", (Object)accessTokenRequest.getResponseType().getType()).append("scopes", accessTokenRequest.getScopes()).toString();
            return new String[]{result};
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }
}

