/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.endpoints;

import java.util.Collection;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.profile.OAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.token.OAuth20TokenRequestValidator;
import org.apereo.cas.support.oauth.validator.token.device.InvalidOAuth20DeviceTokenException;
import org.apereo.cas.support.oauth.validator.token.device.ThrottledOAuth20DeviceUserCodeApprovalException;
import org.apereo.cas.support.oauth.validator.token.device.UnapprovedOAuth20DeviceUserCodeException;
import org.apereo.cas.support.oauth.web.endpoints.BaseOAuth20Controller;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGeneratedResult;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestDataHolder;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20AccessTokenResponseGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20AccessTokenResponseResult;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.accesstoken.AccessTokenFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.Pac4jUtils;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator;
import org.pac4j.core.context.J2EContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.servlet.ModelAndView;

public class OAuth20AccessTokenEndpointController
extends BaseOAuth20Controller {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20AccessTokenEndpointController.class);
    private final OAuth20TokenGenerator accessTokenGenerator;
    private final OAuth20AccessTokenResponseGenerator accessTokenResponseGenerator;
    private final ExpirationPolicy accessTokenExpirationPolicy;
    private final Collection<OAuth20TokenRequestValidator> accessTokenGrantRequestValidators;
    private final ExpirationPolicy deviceTokenExpirationPolicy;
    private final AuditableExecution accessTokenGrantAuditableRequestExtractor;

    public OAuth20AccessTokenEndpointController(ServicesManager servicesManager, TicketRegistry ticketRegistry, AccessTokenFactory accessTokenFactory, PrincipalFactory principalFactory, ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory, OAuth20TokenGenerator accessTokenGenerator, OAuth20AccessTokenResponseGenerator accessTokenResponseGenerator, OAuth20ProfileScopeToAttributesFilter scopeToAttributesFilter, CasConfigurationProperties casProperties, CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator, ExpirationPolicy accessTokenExpirationPolicy, ExpirationPolicy deviceTokenExpirationPolicy, Collection<OAuth20TokenRequestValidator> accessTokenGrantRequestValidators, AuditableExecution accessTokenGrantAuditableRequestExtractor) {
        super(servicesManager, ticketRegistry, accessTokenFactory, principalFactory, webApplicationServiceServiceFactory, scopeToAttributesFilter, casProperties, ticketGrantingTicketCookieGenerator);
        this.accessTokenGenerator = accessTokenGenerator;
        this.accessTokenResponseGenerator = accessTokenResponseGenerator;
        this.accessTokenExpirationPolicy = accessTokenExpirationPolicy;
        this.deviceTokenExpirationPolicy = deviceTokenExpirationPolicy;
        this.accessTokenGrantRequestValidators = accessTokenGrantRequestValidators;
        this.accessTokenGrantAuditableRequestExtractor = accessTokenGrantAuditableRequestExtractor;
    }

    @PostMapping(path={"/oauth2.0/accessToken", "/oauth2.0/token"}, produces={"application/json"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            if (!this.verifyAccessTokenRequest(request, response)) {
                throw new IllegalArgumentException("Access token validation failed");
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return OAuth20Utils.writeError((HttpServletResponse)response, (String)"invalid_request");
        }
        try {
            AccessTokenRequestDataHolder requestHolder = this.examineAndExtractAccessTokenGrantRequest(request, response);
            LOGGER.debug("Creating access token for [{}]", (Object)requestHolder);
            J2EContext context = Pac4jUtils.getPac4jJ2EContext((HttpServletRequest)request, (HttpServletResponse)response);
            OAuth20TokenGeneratedResult tokenResult = this.accessTokenGenerator.generate(requestHolder);
            LOGGER.debug("Access token generated result is: [{}]", (Object)tokenResult);
            return this.generateAccessTokenResponse(request, response, requestHolder, context, tokenResult);
        }
        catch (InvalidOAuth20DeviceTokenException e) {
            LOGGER.error("Could not identify and extract device token request for device token [{}]", (Object)e.getTicketId());
            return OAuth20Utils.writeError((HttpServletResponse)response, (String)"access_denied");
        }
        catch (UnapprovedOAuth20DeviceUserCodeException e) {
            LOGGER.error("User code [{}] is not yet approved for the device token request", (Object)e.getTicketId());
            return OAuth20Utils.writeError((HttpServletResponse)response, (String)"authorization_pending");
        }
        catch (ThrottledOAuth20DeviceUserCodeApprovalException e) {
            LOGGER.error("Check for device user code approval is too quick and is throttled. Requests must slow down");
            return OAuth20Utils.writeError((HttpServletResponse)response, (String)"slow_down");
        }
        catch (Exception e) {
            LOGGER.error("Could not identify and extract access token request", (Throwable)e);
            return OAuth20Utils.writeError((HttpServletResponse)response, (String)"invalid_grant");
        }
    }

    @GetMapping(path={"/oauth2.0/accessToken", "/oauth2.0/token"})
    public ModelAndView handleGetRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.handleRequest(request, response);
    }

    protected ModelAndView generateAccessTokenResponse(HttpServletRequest request, HttpServletResponse response, AccessTokenRequestDataHolder requestHolder, J2EContext context, OAuth20TokenGeneratedResult result) {
        LOGGER.debug("Generating access token response for [{}]", (Object)result);
        long deviceRefreshInterval = Beans.newDuration((String)this.casProperties.getAuthn().getOauth().getDeviceToken().getRefreshInterval()).getSeconds();
        OAuth20AccessTokenResponseResult tokenResult = OAuth20AccessTokenResponseResult.builder().registeredService(requestHolder.getRegisteredService()).service(requestHolder.getService()).accessTokenTimeout(this.accessTokenExpirationPolicy.getTimeToLive()).deviceRefreshInterval(deviceRefreshInterval).deviceTokenTimeout(this.deviceTokenExpirationPolicy.getTimeToLive()).responseType(result.getResponseType().isPresent() ? result.getResponseType().get() : OAuth20ResponseTypes.NONE).casProperties(this.casProperties).generatedToken(result).build();
        return this.accessTokenResponseGenerator.generate(request, response, tokenResult);
    }

    private AccessTokenRequestDataHolder examineAndExtractAccessTokenGrantRequest(HttpServletRequest request, HttpServletResponse response) {
        AuditableContext audit = AuditableContext.builder().httpRequest((Object)request).httpResponse((Object)response).build();
        AuditableExecutionResult accessResult = this.accessTokenGrantAuditableRequestExtractor.execute(audit);
        Optional execResult = accessResult.getExecutionResult();
        if (execResult.isPresent()) {
            return (AccessTokenRequestDataHolder)execResult.get();
        }
        throw new UnsupportedOperationException("Access token request is not supported");
    }

    private boolean verifyAccessTokenRequest(HttpServletRequest request, HttpServletResponse response) {
        if (this.accessTokenGrantRequestValidators.isEmpty()) {
            LOGGER.warn("No validators are defined to examine the access token request for eligibility");
            return false;
        }
        J2EContext context = new J2EContext(request, response);
        return this.accessTokenGrantRequestValidators.stream().filter(ext -> ext.supports(context)).findFirst().orElseThrow(() -> new UnsupportedOperationException("Access token request is not supported")).validate(context);
    }
}

