/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.endpoints;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.profile.OAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.web.endpoints.BaseOAuth20Controller;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.accesstoken.AccessTokenFactory;
import org.apereo.cas.ticket.device.DeviceTokenFactory;
import org.apereo.cas.ticket.device.DeviceUserCode;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.servlet.ModelAndView;

public class OAuth20DeviceUserCodeApprovalEndpointController
extends BaseOAuth20Controller {
    public static final String PARAMETER_USER_CODE = "usercode";
    private final DeviceTokenFactory deviceTokenFactory;

    public OAuth20DeviceUserCodeApprovalEndpointController(ServicesManager servicesManager, TicketRegistry ticketRegistry, AccessTokenFactory accessTokenFactory, PrincipalFactory principalFactory, ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory, OAuth20ProfileScopeToAttributesFilter scopeToAttributesFilter, CasConfigurationProperties casProperties, CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator, DeviceTokenFactory deviceTokenFactory) {
        super(servicesManager, ticketRegistry, accessTokenFactory, principalFactory, webApplicationServiceServiceFactory, scopeToAttributesFilter, casProperties, ticketGrantingTicketCookieGenerator);
        this.deviceTokenFactory = deviceTokenFactory;
    }

    @GetMapping(path={"/oauth2.0/device"})
    public static ModelAndView handleGetRequest(HttpServletRequest request, HttpServletResponse response) {
        Map model = OAuth20DeviceUserCodeApprovalEndpointController.getApprovalModel("");
        return new ModelAndView("oauthDeviceCodeApprovalView", model);
    }

    @PostMapping(path={"/oauth2.0/device"})
    public ModelAndView handlePostRequest(HttpServletRequest request, HttpServletResponse response) {
        String userCode = request.getParameter(PARAMETER_USER_CODE);
        ModelAndView codeNotfound = OAuth20DeviceUserCodeApprovalEndpointController.getModelAndViewForFailure("codenotfound");
        if (StringUtils.isBlank((CharSequence)userCode)) {
            return codeNotfound;
        }
        String codeId = this.deviceTokenFactory.generateDeviceUserCode(userCode);
        DeviceUserCode deviceUserCode = (DeviceUserCode)this.ticketRegistry.getTicket(codeId, DeviceUserCode.class);
        if (deviceUserCode == null) {
            return codeNotfound;
        }
        if (deviceUserCode.isExpired()) {
            return OAuth20DeviceUserCodeApprovalEndpointController.getModelAndViewForFailure("codeexpired");
        }
        if (deviceUserCode.isUserCodeApproved()) {
            return OAuth20DeviceUserCodeApprovalEndpointController.getModelAndViewForFailure("codeapproved");
        }
        deviceUserCode.approveUserCode();
        this.ticketRegistry.updateTicket((Ticket)deviceUserCode);
        return new ModelAndView("oauthDeviceCodeApprovedView", HttpStatus.OK);
    }

    private static ModelAndView getModelAndViewForFailure(String code) {
        return new ModelAndView("oauthDeviceCodeApprovalView", OAuth20DeviceUserCodeApprovalEndpointController.getApprovalModel(code));
    }

    private static Map getApprovalModel(String errorCode) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("prefix", "ODUC");
        if (StringUtils.isNotBlank((CharSequence)errorCode)) {
            map.put("error", errorCode);
        }
        return map;
    }
}

