/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.endpoints;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.profile.OAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.profile.OAuth20UserProfileDataCreator;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.endpoints.BaseOAuth20Controller;
import org.apereo.cas.support.oauth.web.views.OAuth20UserProfileViewRenderer;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.TicketState;
import org.apereo.cas.ticket.accesstoken.AccessToken;
import org.apereo.cas.ticket.accesstoken.AccessTokenFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.Pac4jUtils;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator;
import org.pac4j.core.context.J2EContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;

public class OAuth20UserProfileEndpointController
extends BaseOAuth20Controller {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20UserProfileEndpointController.class);
    private final OAuth20UserProfileViewRenderer userProfileViewRenderer;
    private final OAuth20UserProfileDataCreator userProfileDataCreator;
    private final ResponseEntity expiredAccessTokenResponseEntity;

    public OAuth20UserProfileEndpointController(ServicesManager servicesManager, TicketRegistry ticketRegistry, AccessTokenFactory accessTokenFactory, PrincipalFactory principalFactory, ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory, OAuth20ProfileScopeToAttributesFilter scopeToAttributesFilter, CasConfigurationProperties casProperties, CookieRetrievingCookieGenerator cookieGenerator, OAuth20UserProfileViewRenderer userProfileViewRenderer, OAuth20UserProfileDataCreator userProfileDataCreator) {
        super(servicesManager, ticketRegistry, accessTokenFactory, principalFactory, webApplicationServiceServiceFactory, scopeToAttributesFilter, casProperties, cookieGenerator);
        this.userProfileViewRenderer = userProfileViewRenderer;
        this.userProfileDataCreator = userProfileDataCreator;
        this.expiredAccessTokenResponseEntity = OAuth20UserProfileEndpointController.buildUnauthorizedResponseEntity("expired_accessToken");
    }

    private static ResponseEntity buildUnauthorizedResponseEntity(String code) {
        LinkedMultiValueMap map = new LinkedMultiValueMap(1);
        map.add((Object)"error", (Object)code);
        String value = OAuth20Utils.toJson((Object)map);
        return new ResponseEntity((Object)value, HttpStatus.UNAUTHORIZED);
    }

    @GetMapping(path={"/oauth2.0/profile"}, produces={"application/json"})
    public ResponseEntity<String> handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        TicketGrantingTicket ticketGrantingTicket;
        response.setContentType("application/json");
        J2EContext context = Pac4jUtils.getPac4jJ2EContext((HttpServletRequest)request, (HttpServletResponse)response);
        String accessToken = this.getAccessTokenFromRequest(request);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            LOGGER.error("Missing [{}] from the request", (Object)"access_token");
            return OAuth20UserProfileEndpointController.buildUnauthorizedResponseEntity("missing_accessToken");
        }
        AccessToken accessTokenTicket = (AccessToken)this.ticketRegistry.getTicket(accessToken, AccessToken.class);
        if (accessTokenTicket == null) {
            LOGGER.error("Access token [{}] cannot be found in the ticket registry.", (Object)accessToken);
            return this.expiredAccessTokenResponseEntity;
        }
        if (accessTokenTicket.isExpired()) {
            LOGGER.error("Access token [{}] has expired and will be removed from the ticket registry", (Object)accessToken);
            this.ticketRegistry.deleteTicket(accessToken);
            return this.expiredAccessTokenResponseEntity;
        }
        if (this.casProperties.getLogout().isRemoveDescendantTickets() && ((ticketGrantingTicket = accessTokenTicket.getTicketGrantingTicket()) == null || ticketGrantingTicket.isExpired())) {
            LOGGER.error("Ticket granting ticket [{}] parenting access token [{}] has expired or is not found", (Object)ticketGrantingTicket, (Object)accessTokenTicket);
            this.ticketRegistry.deleteTicket(accessToken);
            return this.expiredAccessTokenResponseEntity;
        }
        this.updateAccessTokenUsage(accessTokenTicket);
        Map<String, Object> map = this.userProfileDataCreator.createFrom(accessTokenTicket, context);
        String value = this.userProfileViewRenderer.render(map, accessTokenTicket);
        return new ResponseEntity((Object)value, HttpStatus.OK);
    }

    private void updateAccessTokenUsage(AccessToken accessTokenTicket) {
        TicketState accessTokenState = (TicketState)TicketState.class.cast(accessTokenTicket);
        accessTokenState.update();
        if (accessTokenTicket.isExpired()) {
            this.ticketRegistry.deleteTicket(accessTokenTicket.getId());
        } else {
            this.ticketRegistry.updateTicket((Ticket)accessTokenTicket);
        }
    }

    protected String getAccessTokenFromRequest(HttpServletRequest request) {
        String authHeader;
        String accessToken = request.getParameter("access_token");
        if (StringUtils.isBlank((CharSequence)accessToken) && StringUtils.isNotBlank((CharSequence)(authHeader = request.getHeader("Authorization"))) && authHeader.toLowerCase().startsWith("bearer".toLowerCase() + " ")) {
            accessToken = authHeader.substring("bearer".length() + 1);
        }
        LOGGER.debug("[{}]: [{}]", (Object)"access_token", (Object)accessToken);
        return accessToken;
    }
}

