/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.mgmt;

import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.accesstoken.AccessToken;
import org.apereo.cas.ticket.refreshtoken.RefreshToken;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.web.BaseCasActuatorEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.annotation.DeleteOperation;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;

@Endpoint(id="oauthTokens", enableByDefault=false)
public class OAuth20TokenManagementEndpoint
extends BaseCasActuatorEndpoint {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20TokenManagementEndpoint.class);
    private final TicketRegistry ticketRegistry;

    public OAuth20TokenManagementEndpoint(CasConfigurationProperties casProperties, TicketRegistry ticketRegistry) {
        super(casProperties);
        this.ticketRegistry = ticketRegistry;
    }

    @ReadOperation
    public Collection<Ticket> getTokens() {
        return this.ticketRegistry.getTickets(ticket -> (ticket instanceof AccessToken || ticket instanceof RefreshToken) && !ticket.isExpired()).sorted(Comparator.comparing(Ticket::getId)).collect(Collectors.toList());
    }

    @ReadOperation
    public Ticket getToken(@Selector String ticketId) {
        Ticket ticket = this.ticketRegistry.getTicket(ticketId, AccessToken.class);
        if (ticket == null) {
            ticket = this.ticketRegistry.getTicket(ticketId, RefreshToken.class);
        }
        if (ticket == null) {
            LOGGER.debug("Ticket [{}] is not found", (Object)ticketId);
            return null;
        }
        if (ticket.isExpired()) {
            LOGGER.debug("Ticket [{}] is has expired", (Object)ticketId);
            return null;
        }
        return ticket;
    }

    @DeleteOperation
    public void deleteToken(@Selector String ticketId) {
        Ticket ticket = this.getToken(ticketId);
        if (ticket != null) {
            this.ticketRegistry.deleteTicket(ticketId);
        }
    }
}

