/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.accesstoken;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.LinkedHashSet;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.DefaultAuthenticationBuilder;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.validator.token.device.InvalidOAuth20DeviceTokenException;
import org.apereo.cas.support.oauth.validator.token.device.ThrottledOAuth20DeviceUserCodeApprovalException;
import org.apereo.cas.support.oauth.validator.token.device.UnapprovedOAuth20DeviceUserCodeException;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGeneratedResult;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestDataHolder;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.TicketState;
import org.apereo.cas.ticket.accesstoken.AccessToken;
import org.apereo.cas.ticket.accesstoken.AccessTokenFactory;
import org.apereo.cas.ticket.code.OAuthCode;
import org.apereo.cas.ticket.device.DeviceToken;
import org.apereo.cas.ticket.device.DeviceTokenFactory;
import org.apereo.cas.ticket.device.DeviceUserCode;
import org.apereo.cas.ticket.refreshtoken.RefreshToken;
import org.apereo.cas.ticket.refreshtoken.RefreshTokenFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20DefaultTokenGenerator
implements OAuth20TokenGenerator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20DefaultTokenGenerator.class);
    protected final AccessTokenFactory accessTokenFactory;
    protected final DeviceTokenFactory deviceTokenFactory;
    protected final RefreshTokenFactory refreshTokenFactory;
    protected final TicketRegistry ticketRegistry;
    protected final CasConfigurationProperties casProperties;

    @Override
    public OAuth20TokenGeneratedResult generate(AccessTokenRequestDataHolder holder) {
        if (OAuth20ResponseTypes.DEVICE_CODE.equals((Object)holder.getResponseType())) {
            return this.generateAccessTokenOAuthDeviceCodeResponseType(holder);
        }
        Pair<AccessToken, RefreshToken> pair = this.generateAccessTokenOAuthGrantTypes(holder);
        return OAuth20DefaultTokenGenerator.generateAccessTokenResult(holder, pair);
    }

    protected OAuth20TokenGeneratedResult generateAccessTokenOAuthDeviceCodeResponseType(AccessTokenRequestDataHolder holder) {
        String deviceCode = holder.getDeviceCode();
        if (StringUtils.isNotBlank((CharSequence)deviceCode)) {
            DeviceToken deviceCodeTicket = this.getDeviceTokenFromTicketRegistry(deviceCode);
            DeviceUserCode deviceUserCode = this.getDeviceUserCodeFromRegistry(deviceCodeTicket);
            if (deviceUserCode.isUserCodeApproved()) {
                LOGGER.debug("Provided user code [{}] linked to device code [{}] is approved", (Object)deviceCodeTicket.getId(), (Object)deviceCode);
                this.ticketRegistry.deleteTicket(deviceCode);
                AccessTokenRequestDataHolder deviceResult = AccessTokenRequestDataHolder.builder().service(holder.getService()).authentication(holder.getAuthentication()).registeredService(holder.getRegisteredService()).ticketGrantingTicket(holder.getTicketGrantingTicket()).grantType(holder.getGrantType()).scopes(new LinkedHashSet<String>()).responseType(holder.getResponseType()).generateRefreshToken(holder.getRegisteredService() != null && holder.isGenerateRefreshToken()).build();
                Pair<AccessToken, RefreshToken> ticketPair = this.generateAccessTokenOAuthGrantTypes(deviceResult);
                return OAuth20DefaultTokenGenerator.generateAccessTokenResult(deviceResult, ticketPair);
            }
            if (deviceCodeTicket.getLastTimeUsed() != null) {
                long interval = Beans.newDuration((String)this.casProperties.getAuthn().getOauth().getDeviceToken().getRefreshInterval()).getSeconds();
                boolean shouldSlowDown = deviceCodeTicket.getLastTimeUsed().plusSeconds(interval).isAfter(ZonedDateTime.now(ZoneOffset.UTC));
                if (shouldSlowDown) {
                    LOGGER.error("Request for user code approval is greater than the configured refresh interval of [{}] second(s)", (Object)interval);
                    throw new ThrottledOAuth20DeviceUserCodeApprovalException(deviceCodeTicket.getId());
                }
            }
            deviceCodeTicket.update();
            this.ticketRegistry.updateTicket((Ticket)deviceCodeTicket);
            LOGGER.error("Provided user code [{}] linked to device code [{}] is NOT approved yet", (Object)deviceCodeTicket.getId(), (Object)deviceCode);
            throw new UnapprovedOAuth20DeviceUserCodeException(deviceCodeTicket.getId());
        }
        Pair<DeviceToken, DeviceUserCode> deviceTokens = this.createDeviceTokensInTicketRegistry(holder);
        return OAuth20TokenGeneratedResult.builder().responseType(holder.getResponseType()).registeredService(holder.getRegisteredService()).deviceCode(((DeviceToken)deviceTokens.getLeft()).getId()).userCode(((DeviceUserCode)deviceTokens.getValue()).getId()).build();
    }

    private DeviceUserCode getDeviceUserCodeFromRegistry(DeviceToken deviceCodeTicket) {
        DeviceUserCode userCode = (DeviceUserCode)this.ticketRegistry.getTicket(deviceCodeTicket.getUserCode(), DeviceUserCode.class);
        if (userCode == null) {
            LOGGER.error("Provided user code [{}] is invalid or expired and cannot be found in the ticket registry", (Object)deviceCodeTicket.getUserCode());
            throw new InvalidOAuth20DeviceTokenException(deviceCodeTicket.getUserCode());
        }
        if (userCode.isExpired()) {
            this.ticketRegistry.deleteTicket(userCode.getId());
            LOGGER.error("Provided device code [{}] has expired and will be removed from the ticket registry", (Object)deviceCodeTicket.getUserCode());
            throw new InvalidOAuth20DeviceTokenException(deviceCodeTicket.getUserCode());
        }
        return userCode;
    }

    private DeviceToken getDeviceTokenFromTicketRegistry(String deviceCode) {
        DeviceToken deviceCodeTicket = (DeviceToken)this.ticketRegistry.getTicket(deviceCode, DeviceToken.class);
        if (deviceCodeTicket == null) {
            LOGGER.error("Provided device code [{}] is invalid or expired and cannot be found in the ticket registry", (Object)deviceCode);
            throw new InvalidOAuth20DeviceTokenException(deviceCode);
        }
        if (deviceCodeTicket.isExpired()) {
            this.ticketRegistry.deleteTicket(deviceCode);
            LOGGER.error("Provided device code [{}] has expired and will be removed from the ticket registry", (Object)deviceCode);
            throw new InvalidOAuth20DeviceTokenException(deviceCode);
        }
        return deviceCodeTicket;
    }

    private Pair<DeviceToken, DeviceUserCode> createDeviceTokensInTicketRegistry(AccessTokenRequestDataHolder holder) {
        DeviceToken deviceToken = this.deviceTokenFactory.createDeviceCode(holder.getService());
        LOGGER.debug("Created device code token [{}]", (Object)deviceToken.getId());
        DeviceUserCode deviceUserCode = this.deviceTokenFactory.createDeviceUserCode(deviceToken);
        LOGGER.debug("Created device user code token [{}]", (Object)deviceUserCode.getId());
        this.addTicketToRegistry((Ticket)deviceToken);
        LOGGER.debug("Added device token [{}] to registry", (Object)deviceToken);
        this.addTicketToRegistry((Ticket)deviceUserCode);
        LOGGER.debug("Added device user token [{}] to registry", (Object)deviceUserCode);
        return Pair.of((Object)deviceToken, (Object)deviceUserCode);
    }

    protected Pair<AccessToken, RefreshToken> generateAccessTokenOAuthGrantTypes(AccessTokenRequestDataHolder holder) {
        LOGGER.debug("Creating access token for [{}]", (Object)holder.getService());
        Authentication authn = DefaultAuthenticationBuilder.newInstance((Authentication)holder.getAuthentication()).addAttribute("grant_type", (Object)holder.getGrantType().toString()).addAttribute("scope", holder.getScopes()).addAttribute("client_id", (Object)holder.getRegisteredService().getClientId()).build();
        LOGGER.debug("Creating access token for [{}]", (Object)holder);
        TicketGrantingTicket ticketGrantingTicket = holder.getTicketGrantingTicket();
        AccessToken accessToken = this.accessTokenFactory.create(holder.getService(), authn, ticketGrantingTicket, holder.getScopes());
        LOGGER.debug("Created access token [{}]", (Object)accessToken);
        this.addTicketToRegistry((Ticket)accessToken, ticketGrantingTicket);
        LOGGER.debug("Added access token [{}] to registry", (Object)accessToken);
        this.updateOAuthCode(holder);
        RefreshToken refreshToken = (RefreshToken)FunctionUtils.doIf((boolean)holder.isGenerateRefreshToken(), () -> this.generateRefreshToken(holder), () -> {
            LOGGER.debug("Service [{}] is not able/allowed to receive refresh tokens", (Object)holder.getService());
            return null;
        }).get();
        return Pair.of((Object)accessToken, (Object)refreshToken);
    }

    protected void updateOAuthCode(AccessTokenRequestDataHolder holder) {
        if (holder.getToken() instanceof OAuthCode) {
            TicketState codeState = (TicketState)TicketState.class.cast(holder.getToken());
            codeState.update();
            if (holder.getToken().isExpired()) {
                this.ticketRegistry.deleteTicket(holder.getToken().getId());
            } else {
                this.ticketRegistry.updateTicket((Ticket)holder.getToken());
            }
            this.ticketRegistry.updateTicket((Ticket)holder.getTicketGrantingTicket());
        }
    }

    protected void addTicketToRegistry(Ticket ticket, TicketGrantingTicket ticketGrantingTicket) {
        LOGGER.debug("Adding ticket [{}] to registry", (Object)ticket);
        this.ticketRegistry.addTicket(ticket);
        if (ticketGrantingTicket != null) {
            LOGGER.debug("Updating parent ticket-granting ticket [{}]", (Object)ticketGrantingTicket);
            this.ticketRegistry.updateTicket((Ticket)ticketGrantingTicket);
        }
    }

    protected void addTicketToRegistry(Ticket ticket) {
        this.addTicketToRegistry(ticket, null);
    }

    protected RefreshToken generateRefreshToken(AccessTokenRequestDataHolder responseHolder) {
        LOGGER.debug("Creating refresh token for [{}]", (Object)responseHolder.getService());
        RefreshToken refreshToken = this.refreshTokenFactory.create(responseHolder.getService(), responseHolder.getAuthentication(), responseHolder.getTicketGrantingTicket(), responseHolder.getScopes());
        LOGGER.debug("Adding refresh token [{}] to the registry", (Object)refreshToken);
        this.addTicketToRegistry((Ticket)refreshToken, responseHolder.getTicketGrantingTicket());
        return refreshToken;
    }

    private static OAuth20TokenGeneratedResult generateAccessTokenResult(AccessTokenRequestDataHolder holder, Pair<AccessToken, RefreshToken> pair) {
        return OAuth20TokenGeneratedResult.builder().registeredService(holder.getRegisteredService()).accessToken((AccessToken)pair.getKey()).refreshToken((RefreshToken)pair.getValue()).grantType(holder.getGrantType()).responseType(holder.getResponseType()).build();
    }

    @Generated
    public OAuth20DefaultTokenGenerator(AccessTokenFactory accessTokenFactory, DeviceTokenFactory deviceTokenFactory, RefreshTokenFactory refreshTokenFactory, TicketRegistry ticketRegistry, CasConfigurationProperties casProperties) {
        this.accessTokenFactory = accessTokenFactory;
        this.deviceTokenFactory = deviceTokenFactory;
        this.refreshTokenFactory = refreshTokenFactory;
        this.ticketRegistry = ticketRegistry;
        this.casProperties = casProperties;
    }
}

