/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.accesstoken.ext;

import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.model.support.oauth.OAuthProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestDataHolder;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.BaseAccessTokenGrantRequestExtractor;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.OAuthToken;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessTokenAuthorizationCodeGrantRequestExtractor
extends BaseAccessTokenGrantRequestExtractor {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessTokenAuthorizationCodeGrantRequestExtractor.class);
    protected final ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory;

    public AccessTokenAuthorizationCodeGrantRequestExtractor(ServicesManager servicesManager, TicketRegistry ticketRegistry, CentralAuthenticationService centralAuthenticationService, OAuthProperties oAuthProperties, ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory) {
        super(servicesManager, ticketRegistry, centralAuthenticationService, oAuthProperties);
        this.webApplicationServiceServiceFactory = webApplicationServiceServiceFactory;
    }

    @Override
    public AccessTokenRequestDataHolder extract(HttpServletRequest request, HttpServletResponse response) {
        String grantType = request.getParameter("grant_type");
        Set scopes = OAuth20Utils.parseRequestScopes((HttpServletRequest)request);
        LOGGER.debug("OAuth grant type is [{}]", (Object)grantType);
        String redirectUri = this.getRegisteredServiceIdentifierFromRequest(request);
        OAuthRegisteredService registeredService = this.getOAuthRegisteredServiceBy(request);
        if (registeredService == null) {
            throw new UnauthorizedServiceException("Unable to locate service in registry for redirect URI " + redirectUri);
        }
        OAuthToken token = this.getOAuthTokenFromRequest(request);
        if (token == null) {
            throw new InvalidTicketException(this.getOAuthParameter(request));
        }
        WebApplicationService service = (WebApplicationService)this.webApplicationServiceServiceFactory.createService(redirectUri);
        scopes.addAll(token.getScopes());
        boolean generateRefreshToken = this.isAllowedToGenerateRefreshToken() && registeredService.isGenerateRefreshToken();
        AccessTokenRequestDataHolder.AccessTokenRequestDataHolderBuilder builder = AccessTokenRequestDataHolder.builder().scopes(scopes).service((Service)service).authentication(token.getAuthentication()).registeredService(registeredService).grantType(this.getGrantType()).generateRefreshToken(generateRefreshToken).token(token).ticketGrantingTicket(token.getTicketGrantingTicket());
        return this.extractInternal(request, response, builder);
    }

    protected AccessTokenRequestDataHolder extractInternal(HttpServletRequest request, HttpServletResponse response, AccessTokenRequestDataHolder.AccessTokenRequestDataHolderBuilder builder) {
        return builder.build();
    }

    protected String getRegisteredServiceIdentifierFromRequest(HttpServletRequest request) {
        return request.getParameter("redirect_uri");
    }

    protected boolean isAllowedToGenerateRefreshToken() {
        return true;
    }

    protected String getOAuthParameterName() {
        return "code";
    }

    protected String getOAuthParameter(HttpServletRequest request) {
        return request.getParameter(this.getOAuthParameterName());
    }

    protected OAuthToken getOAuthTokenFromRequest(HttpServletRequest request) {
        OAuthToken token = (OAuthToken)this.ticketRegistry.getTicket(this.getOAuthParameter(request), OAuthToken.class);
        if (token == null || token.isExpired()) {
            LOGGER.error("OAuth token indicated by parameter [{}] has expired or not found: [{}]", (Object)this.getOAuthParameter(request), (Object)token);
            if (token != null) {
                this.ticketRegistry.deleteTicket(token.getId());
            }
            return null;
        }
        return token;
    }

    @Override
    public boolean supports(HttpServletRequest context) {
        String grantType = context.getParameter("grant_type");
        return OAuth20Utils.isGrantType((String)grantType, (OAuth20GrantTypes)this.getGrantType());
    }

    @Override
    public OAuth20GrantTypes getGrantType() {
        return OAuth20GrantTypes.AUTHORIZATION_CODE;
    }

    @Override
    public OAuth20ResponseTypes getResponseType() {
        return OAuth20ResponseTypes.NONE;
    }

    protected OAuthRegisteredService getOAuthRegisteredServiceBy(HttpServletRequest request) {
        String redirectUri = this.getRegisteredServiceIdentifierFromRequest(request);
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByRedirectUri((ServicesManager)this.servicesManager, (String)redirectUri);
        LOGGER.debug("Located registered service [{}]", (Object)registeredService);
        return registeredService;
    }
}

