/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.accesstoken.ext;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.model.support.oauth.OAuthProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.authenticator.OAuth20CasAuthenticationBuilder;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestDataHolder;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.BaseAccessTokenGrantRequestExtractor;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.Pac4jUtils;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.profile.AnonymousProfile;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessTokenDeviceCodeResponseRequestExtractor
extends BaseAccessTokenGrantRequestExtractor {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessTokenDeviceCodeResponseRequestExtractor.class);
    private final OAuth20CasAuthenticationBuilder authenticationBuilder;
    private final AuditableExecution registeredServiceAccessStrategyEnforcer;

    public AccessTokenDeviceCodeResponseRequestExtractor(ServicesManager servicesManager, TicketRegistry ticketRegistry, CentralAuthenticationService centralAuthenticationService, OAuthProperties oAuthProperties, OAuth20CasAuthenticationBuilder authenticationBuilder, AuditableExecution registeredServiceAccessStrategyEnforcer) {
        super(servicesManager, ticketRegistry, centralAuthenticationService, oAuthProperties);
        this.authenticationBuilder = authenticationBuilder;
        this.registeredServiceAccessStrategyEnforcer = registeredServiceAccessStrategyEnforcer;
    }

    @Override
    public AccessTokenRequestDataHolder extract(HttpServletRequest request, HttpServletResponse response) {
        String clientId = request.getParameter("client_id");
        LOGGER.debug("Locating OAuth registered service by client id [{}]", (Object)clientId);
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)this.servicesManager, (String)clientId);
        LOGGER.debug("Located OAuth registered service [{}]", (Object)registeredService);
        String deviceCode = request.getParameter("code");
        J2EContext context = Pac4jUtils.getPac4jJ2EContext((HttpServletRequest)request, (HttpServletResponse)response);
        Service service = this.authenticationBuilder.buildService(registeredService, context, false);
        LOGGER.debug("Authenticating the OAuth request indicated by [{}]", (Object)service);
        Authentication authentication = this.authenticationBuilder.build((UserProfile)new AnonymousProfile(), registeredService, context, service);
        AuditableContext audit = AuditableContext.builder().service(service).registeredService((RegisteredService)registeredService).authentication(authentication).build();
        AuditableExecutionResult accessResult = this.registeredServiceAccessStrategyEnforcer.execute(audit);
        accessResult.throwExceptionIfNeeded();
        return AccessTokenRequestDataHolder.builder().service(service).authentication(authentication).registeredService(registeredService).responseType(this.getResponseType()).grantType(this.getGrantType()).generateRefreshToken(registeredService != null && registeredService.isGenerateRefreshToken()).deviceCode(deviceCode).build();
    }

    @Override
    public boolean supports(HttpServletRequest context) {
        String responseType = context.getParameter("response_type");
        String clientId = context.getParameter("client_id");
        return OAuth20Utils.isResponseType((String)responseType, (OAuth20ResponseTypes)OAuth20ResponseTypes.DEVICE_CODE) && StringUtils.isNotBlank((CharSequence)clientId);
    }

    @Override
    public OAuth20GrantTypes getGrantType() {
        return OAuth20GrantTypes.NONE;
    }

    @Override
    public OAuth20ResponseTypes getResponseType() {
        return OAuth20ResponseTypes.DEVICE_CODE;
    }

    @Override
    public boolean requestMustBeAuthenticated() {
        return false;
    }
}

