/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.accesstoken.response;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGeneratedResult;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20AccessTokenResponseGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20AccessTokenResponseResult;
import org.apereo.inspektr.audit.annotation.Audit;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

public class OAuth20DefaultAccessTokenResponseGenerator
implements OAuth20AccessTokenResponseGenerator {
    private static final ObjectMapper MAPPER = new ObjectMapper().findAndRegisterModules();

    @Override
    @Audit(action="OAUTH2_ACCESS_TOKEN_RESPONSE", actionResolverName="OAUTH2_ACCESS_TOKEN_RESPONSE_ACTION_RESOLVER", resourceResolverName="OAUTH2_ACCESS_TOKEN_RESPONSE_RESOURCE_RESOLVER")
    public ModelAndView generate(HttpServletRequest request, HttpServletResponse response, OAuth20AccessTokenResponseResult result) {
        if (OAuth20DefaultAccessTokenResponseGenerator.shouldGenerateDeviceFlowResponse(result)) {
            return this.generateResponseForDeviceToken(request, response, result);
        }
        return this.generateResponseForAccessToken(request, response, result);
    }

    private static boolean shouldGenerateDeviceFlowResponse(OAuth20AccessTokenResponseResult result) {
        OAuth20TokenGeneratedResult generatedToken = result.getGeneratedToken();
        return OAuth20ResponseTypes.DEVICE_CODE == result.getResponseType() && generatedToken.getDeviceCode().isPresent() && generatedToken.getUserCode().isPresent() && generatedToken.getAccessToken().isEmpty();
    }

    protected ModelAndView generateResponseForDeviceToken(HttpServletRequest request, HttpServletResponse response, OAuth20AccessTokenResponseResult result) {
        Map model = this.getDeviceTokenResponseModel(result);
        return new ModelAndView((View)new MappingJackson2JsonView(MAPPER), model);
    }

    protected Map getDeviceTokenResponseModel(OAuth20AccessTokenResponseResult result) {
        LinkedHashMap<String, Object> model = new LinkedHashMap<String, Object>();
        String uri = result.getCasProperties().getServer().getPrefix().concat("/oauth2.0").concat("/").concat("device");
        model.put("verification_uri", uri);
        model.put("expires_in", result.getDeviceTokenTimeout());
        result.getGeneratedToken().getUserCode().ifPresent(c -> model.put("user_code", c));
        result.getGeneratedToken().getDeviceCode().ifPresent(c -> model.put("device_code", c));
        model.put("interval", result.getDeviceRefreshInterval());
        return model;
    }

    protected ModelAndView generateResponseForAccessToken(HttpServletRequest request, HttpServletResponse response, OAuth20AccessTokenResponseResult result) {
        Map model = this.getAccessTokenResponseModel(request, response, result);
        return new ModelAndView((View)new MappingJackson2JsonView(MAPPER), model);
    }

    protected Map getAccessTokenResponseModel(HttpServletRequest request, HttpServletResponse response, OAuth20AccessTokenResponseResult result) {
        LinkedHashMap<String, Object> model = new LinkedHashMap<String, Object>();
        OAuth20TokenGeneratedResult generatedToken = result.getGeneratedToken();
        generatedToken.getAccessToken().ifPresent(t -> {
            model.put("access_token", t.getId());
            model.put("scope", t.getScopes());
        });
        generatedToken.getRefreshToken().ifPresent(t -> model.put("refresh_token", t.getId()));
        model.put("token_type", "bearer");
        model.put("expires_in", result.getAccessTokenTimeout());
        return model;
    }
}

