/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.callback;

import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestDataHolder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationResponseBuilder;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.code.OAuthCode;
import org.apereo.cas.ticket.code.OAuthCodeFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

public class OAuth20AuthorizationCodeAuthorizationResponseBuilder
implements OAuth20AuthorizationResponseBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20AuthorizationCodeAuthorizationResponseBuilder.class);
    protected final TicketRegistry ticketRegistry;
    private final OAuthCodeFactory oAuthCodeFactory;

    @Override
    public View build(J2EContext context, String clientId, AccessTokenRequestDataHolder holder) {
        Authentication authentication = holder.getAuthentication();
        OAuthCode code = this.oAuthCodeFactory.create(holder.getService(), authentication, holder.getTicketGrantingTicket(), holder.getScopes(), holder.getCodeChallenge(), holder.getCodeChallengeMethod());
        LOGGER.debug("Generated OAuth code: [{}]", (Object)code);
        this.ticketRegistry.addTicket((Ticket)code);
        return OAuth20AuthorizationCodeAuthorizationResponseBuilder.buildCallbackViewViaRedirectUri(context, clientId, authentication, code);
    }

    @Override
    public boolean supports(J2EContext context) {
        String responseType = context.getRequestParameter("response_type");
        return StringUtils.equalsIgnoreCase((CharSequence)responseType, (CharSequence)OAuth20ResponseTypes.CODE.getType());
    }

    private static View buildCallbackViewViaRedirectUri(J2EContext context, String clientId, Authentication authentication, OAuthCode code) {
        Map attributes = authentication.getAttributes();
        String state = attributes.get("state").toString();
        String nonce = attributes.get("nonce").toString();
        String redirectUri = context.getRequestParameter("redirect_uri");
        LOGGER.debug("Authorize request verification successful for client [{}] with redirect uri [{}]", (Object)clientId, (Object)redirectUri);
        String callbackUrl = redirectUri;
        callbackUrl = CommonHelper.addParameter((String)callbackUrl, (String)"code", (String)code.getId());
        if (StringUtils.isNotBlank((CharSequence)state)) {
            callbackUrl = CommonHelper.addParameter((String)callbackUrl, (String)"state", (String)state);
        }
        if (StringUtils.isNotBlank((CharSequence)nonce)) {
            callbackUrl = CommonHelper.addParameter((String)callbackUrl, (String)"nonce", (String)nonce);
        }
        LOGGER.debug("Redirecting to URL [{}]", (Object)callbackUrl);
        return new RedirectView(callbackUrl);
    }

    @Generated
    public OAuth20AuthorizationCodeAuthorizationResponseBuilder(TicketRegistry ticketRegistry, OAuthCodeFactory oAuthCodeFactory) {
        this.ticketRegistry = ticketRegistry;
        this.oAuthCodeFactory = oAuthCodeFactory;
    }
}

