/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.callback;

import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGeneratedResult;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestDataHolder;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20AccessTokenResponseGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20AccessTokenResponseResult;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationResponseBuilder;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.pac4j.core.context.J2EContext;
import org.springframework.web.servlet.View;

public class OAuth20ResourceOwnerCredentialsResponseBuilder
implements OAuth20AuthorizationResponseBuilder {
    private final OAuth20AccessTokenResponseGenerator accessTokenResponseGenerator;
    private final OAuth20TokenGenerator accessTokenGenerator;
    private final ExpirationPolicy accessTokenExpirationPolicy;
    private final CasConfigurationProperties casProperties;

    @Override
    public View build(J2EContext context, String clientId, AccessTokenRequestDataHolder holder) {
        OAuth20TokenGeneratedResult accessTokenResult = this.accessTokenGenerator.generate(holder);
        OAuth20AccessTokenResponseResult result = OAuth20AccessTokenResponseResult.builder().registeredService(holder.getRegisteredService()).service(holder.getService()).accessTokenTimeout(this.accessTokenExpirationPolicy.getTimeToLive()).responseType(OAuth20Utils.getResponseType((J2EContext)context)).casProperties(this.casProperties).generatedToken(accessTokenResult).build();
        this.accessTokenResponseGenerator.generate(context.getRequest(), context.getResponse(), result);
        return null;
    }

    @Override
    public boolean supports(J2EContext context) {
        String grantType = context.getRequestParameter("grant_type");
        return OAuth20Utils.isGrantType((String)grantType, (OAuth20GrantTypes)OAuth20GrantTypes.PASSWORD);
    }

    @Generated
    public OAuth20ResourceOwnerCredentialsResponseBuilder(OAuth20AccessTokenResponseGenerator accessTokenResponseGenerator, OAuth20TokenGenerator accessTokenGenerator, ExpirationPolicy accessTokenExpirationPolicy, CasConfigurationProperties casProperties) {
        this.accessTokenResponseGenerator = accessTokenResponseGenerator;
        this.accessTokenGenerator = accessTokenGenerator;
        this.accessTokenExpirationPolicy = accessTokenExpirationPolicy;
        this.casProperties = casProperties;
    }
}

