/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.views;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.views.ConsentApprovalViewResolver;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;

public class OAuth20ConsentApprovalViewResolver
implements ConsentApprovalViewResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20ConsentApprovalViewResolver.class);
    protected final CasConfigurationProperties casProperties;

    @Override
    public ModelAndView resolve(J2EContext context, OAuthRegisteredService service) {
        String bypassApprovalParameter = context.getRequestParameter("bypass_approval_prompt");
        if (StringUtils.isBlank((CharSequence)bypassApprovalParameter)) {
            bypassApprovalParameter = (String)context.getSessionStore().get((WebContext)context, "bypass_approval_prompt");
        }
        LOGGER.trace("Bypassing approval prompt for service [{}]: [{}]", (Object)service, (Object)bypassApprovalParameter);
        if (Boolean.TRUE.toString().equalsIgnoreCase(bypassApprovalParameter) || this.isConsentApprovalBypassed(context, service)) {
            context.getSessionStore().set((WebContext)context, "bypass_approval_prompt", (Object)Boolean.TRUE.toString());
            return new ModelAndView();
        }
        return this.redirectToApproveView(context, service);
    }

    protected boolean isConsentApprovalBypassed(J2EContext context, OAuthRegisteredService service) {
        return service.isBypassApprovalPrompt();
    }

    protected ModelAndView redirectToApproveView(J2EContext ctx, OAuthRegisteredService svc) {
        String callbackUrl = ctx.getFullRequestURL();
        LOGGER.trace("callbackUrl: [{}]", (Object)callbackUrl);
        URIBuilder url = new URIBuilder(callbackUrl);
        url.addParameter("bypass_approval_prompt", Boolean.TRUE.toString());
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("service", svc);
        model.put("callbackUrl", url.toString());
        model.put("serviceName", svc.getName());
        model.put("deniedApprovalUrl", svc.getAccessStrategy().getUnauthorizedRedirectUrl());
        this.prepareApprovalViewModel(model, ctx, svc);
        return this.getApprovalModelAndView(model);
    }

    protected ModelAndView getApprovalModelAndView(Map<String, Object> model) {
        return new ModelAndView(this.getApprovalViewName(), model);
    }

    protected String getApprovalViewName() {
        return "oauthConfirmView";
    }

    protected void prepareApprovalViewModel(Map<String, Object> model, J2EContext ctx, OAuthRegisteredService svc) {
    }

    @Generated
    public OAuth20ConsentApprovalViewResolver(CasConfigurationProperties casProperties) {
        this.casProperties = casProperties;
    }
}

