/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.support.oauth.web.OAuth20HandlerInterceptorAdapter;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenGrantRequestExtractor;
import org.apereo.cas.throttle.AuthenticationThrottlingExecutionPlan;
import org.apereo.cas.throttle.AuthenticationThrottlingExecutionPlanConfigurer;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.DirectClient;
import org.pac4j.core.config.Config;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.http.adapter.JEEHttpActionAdapter;
import org.pac4j.springframework.web.SecurityInterceptor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Configuration(value="casOAuth20ThrottleConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasOAuth20ThrottleConfiguration {
    @Autowired
    @Qualifier(value="oauthSecConfig")
    private ObjectProvider<Config> oauthSecConfig;
    @Autowired
    @Qualifier(value="accessTokenGrantRequestExtractors")
    private Collection<AccessTokenGrantRequestExtractor> accessTokenGrantRequestExtractors;

    @ConditionalOnMissingBean(name={"requiresAuthenticationAuthorizeInterceptor"})
    @Bean
    public SecurityInterceptor requiresAuthenticationAuthorizeInterceptor() {
        SecurityInterceptor interceptor = new SecurityInterceptor((Config)this.oauthSecConfig.getObject(), "CasOAuthClient", (HttpActionAdapter)JEEHttpActionAdapter.INSTANCE);
        interceptor.setAuthorizers("");
        return interceptor;
    }

    @ConditionalOnMissingBean(name={"requiresAuthenticationAccessTokenInterceptor"})
    @Bean
    public SecurityInterceptor requiresAuthenticationAccessTokenInterceptor() {
        Config secConfig = (Config)this.oauthSecConfig.getObject();
        String clients = Objects.requireNonNull(secConfig).getClients().findAllClients().stream().filter(client -> client instanceof DirectClient).map(Client::getName).collect(Collectors.joining(","));
        SecurityInterceptor interceptor = new SecurityInterceptor((Config)this.oauthSecConfig.getObject(), clients, (HttpActionAdapter)JEEHttpActionAdapter.INSTANCE);
        interceptor.setAuthorizers("");
        return interceptor;
    }

    @ConditionalOnMissingBean(name={"oauthHandlerInterceptorAdapter"})
    @Bean
    @RefreshScope
    public HandlerInterceptor oauthHandlerInterceptorAdapter() {
        return new OAuth20HandlerInterceptorAdapter((HandlerInterceptorAdapter)this.requiresAuthenticationAccessTokenInterceptor(), (HandlerInterceptorAdapter)this.requiresAuthenticationAuthorizeInterceptor(), this.accessTokenGrantRequestExtractors);
    }

    @Bean
    public AuthenticationThrottlingExecutionPlanConfigurer oauthAuthenticationThrottlingExecutionPlanConfigurer() {
        return plan -> plan.registerAuthenticationThrottleInterceptor(this.oauthHandlerInterceptorAdapter());
    }

    @Configuration(value="oauthThrottleWebMvcConfigurer")
    static class CasOAuthThrottleWebMvcConfigurer
    implements WebMvcConfigurer {
        @Autowired
        @Qualifier(value="authenticationThrottlingExecutionPlan")
        private ObjectProvider<AuthenticationThrottlingExecutionPlan> authenticationThrottlingExecutionPlan;

        CasOAuthThrottleWebMvcConfigurer() {
        }

        public void addInterceptors(InterceptorRegistry registry) {
            Objects.requireNonNull((AuthenticationThrottlingExecutionPlan)this.authenticationThrottlingExecutionPlan.getObject()).getAuthenticationThrottleInterceptors().forEach(handler -> {
                String baseUrl = "/oauth2.0".concat("/");
                registry.addInterceptor(handler).addPathPatterns(new String[]{baseUrl.concat("rptAuthzRequest").concat("*")}).addPathPatterns(new String[]{baseUrl.concat("rqpClaims").concat("*")}).addPathPatterns(new String[]{baseUrl.concat("umaJwks").concat("*")}).addPathPatterns(new String[]{baseUrl.concat("permission").concat("*")}).addPathPatterns(new String[]{baseUrl.concat("policy").concat("*")}).addPathPatterns(new String[]{baseUrl.concat("register").concat("*")}).addPathPatterns(new String[]{baseUrl.concat("resourceSet").concat("*")}).addPathPatterns(new String[]{baseUrl.concat("authorize").concat("*")}).addPathPatterns(new String[]{baseUrl.concat("accessToken").concat("*")}).addPathPatterns(new String[]{baseUrl.concat("token").concat("*")}).addPathPatterns(new String[]{baseUrl.concat("introspect").concat("*")}).addPathPatterns(new String[]{baseUrl.concat("callbackAuthorize").concat("*")}).addPathPatterns(new String[]{baseUrl.concat("device").concat("*")}).addPathPatterns(new String[]{baseUrl.concat("profile").concat("*")});
            });
        }
    }
}

