/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20AuthorizationRequestValidator;
import org.apereo.cas.support.oauth.web.OAuth20HandlerInterceptorAdapter;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenGrantRequestExtractor;
import org.apereo.cas.throttle.AuthenticationThrottlingExecutionPlan;
import org.apereo.cas.throttle.AuthenticationThrottlingExecutionPlanConfigurer;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.DirectClient;
import org.pac4j.core.config.Config;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.http.adapter.JEEHttpActionAdapter;
import org.pac4j.springframework.web.SecurityInterceptor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(value="casOAuth20ThrottleConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasOAuth20ThrottleConfiguration {
    @Autowired
    @Qualifier(value="oauthSecConfig")
    private ObjectProvider<Config> oauthSecConfig;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="accessTokenGrantRequestExtractors")
    private Collection<AccessTokenGrantRequestExtractor> accessTokenGrantRequestExtractors;
    @Autowired
    @Qualifier(value="oauthAuthorizationRequestValidators")
    private Set<OAuth20AuthorizationRequestValidator> oauthAuthorizationRequestValidators;

    @ConditionalOnMissingBean(name={"requiresAuthenticationAuthorizeInterceptor"})
    @Bean
    public HandlerInterceptor requiresAuthenticationAuthorizeInterceptor() {
        SecurityInterceptor interceptor = new SecurityInterceptor((Config)this.oauthSecConfig.getObject(), "CasOAuthClient", (HttpActionAdapter)JEEHttpActionAdapter.INSTANCE);
        interceptor.setAuthorizers("isFullyAuthenticated");
        return interceptor;
    }

    @ConditionalOnMissingBean(name={"requiresAuthenticationAccessTokenInterceptor"})
    @Bean
    public HandlerInterceptor requiresAuthenticationAccessTokenInterceptor() {
        Config secConfig = (Config)this.oauthSecConfig.getObject();
        String clients = Objects.requireNonNull(secConfig).getClients().findAllClients().stream().filter(client -> client instanceof DirectClient).map(Client::getName).collect(Collectors.joining(","));
        SecurityInterceptor interceptor = new SecurityInterceptor((Config)this.oauthSecConfig.getObject(), clients, (HttpActionAdapter)JEEHttpActionAdapter.INSTANCE);
        interceptor.setAuthorizers("isFullyAuthenticated");
        return interceptor;
    }

    @ConditionalOnMissingBean(name={"oauthHandlerInterceptorAdapter"})
    @Bean
    @RefreshScope
    public HandlerInterceptor oauthHandlerInterceptorAdapter() {
        return new OAuth20HandlerInterceptorAdapter(this.requiresAuthenticationAccessTokenInterceptor(), this.requiresAuthenticationAuthorizeInterceptor(), this.accessTokenGrantRequestExtractors, (ServicesManager)this.servicesManager.getObject(), ((Config)this.oauthSecConfig.getObject()).getSessionStore(), this.oauthAuthorizationRequestValidators);
    }

    @Bean
    public AuthenticationThrottlingExecutionPlanConfigurer oauthAuthenticationThrottlingExecutionPlanConfigurer() {
        return plan -> plan.registerAuthenticationThrottleInterceptor(this.oauthHandlerInterceptorAdapter());
    }

    @Configuration(value="oauthThrottleWebMvcConfigurer")
    static class CasOAuthThrottleWebMvcConfigurer
    implements WebMvcConfigurer {
        @Autowired
        @Qualifier(value="authenticationThrottlingExecutionPlan")
        private ObjectProvider<AuthenticationThrottlingExecutionPlan> authenticationThrottlingExecutionPlan;

        CasOAuthThrottleWebMvcConfigurer() {
        }

        public void addInterceptors(InterceptorRegistry registry) {
            Objects.requireNonNull((AuthenticationThrottlingExecutionPlan)this.authenticationThrottlingExecutionPlan.getObject()).getAuthenticationThrottleInterceptors().forEach(handler -> registry.addInterceptor(handler).addPathPatterns(new String[]{"/oauth2.0".concat("/*")}));
        }
    }
}

