/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.audit.AuditTrailRecordResolutionPlanConfigurer;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.CasServerProperties;
import org.apereo.cas.configuration.model.core.util.EncryptionOptionalSigningOptionalJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.cookie.CookieProperties;
import org.apereo.cas.configuration.model.support.oauth.CsrfCookieProperties;
import org.apereo.cas.configuration.model.support.oauth.OAuthProperties;
import org.apereo.cas.configuration.model.support.replication.CookieSessionReplicationProperties;
import org.apereo.cas.logout.LogoutExecutionPlanConfigurer;
import org.apereo.cas.pac4j.DistributedJEESessionStore;
import org.apereo.cas.services.RegisteredServiceCipherExecutor;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20ClientIdAwareProfileManager;
import org.apereo.cas.support.oauth.authenticator.OAuth20AccessTokenAuthenticator;
import org.apereo.cas.support.oauth.authenticator.OAuth20AuthenticationClientProvider;
import org.apereo.cas.support.oauth.authenticator.OAuth20CasAuthenticationBuilder;
import org.apereo.cas.support.oauth.authenticator.OAuth20ClientIdClientSecretAuthenticator;
import org.apereo.cas.support.oauth.authenticator.OAuth20DefaultCasAuthenticationBuilder;
import org.apereo.cas.support.oauth.authenticator.OAuth20ProofKeyCodeExchangeAuthenticator;
import org.apereo.cas.support.oauth.authenticator.OAuth20RefreshTokenAuthenticator;
import org.apereo.cas.support.oauth.authenticator.OAuth20UsernamePasswordAuthenticator;
import org.apereo.cas.support.oauth.profile.DefaultOAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.profile.DefaultOAuth20UserProfileDataCreator;
import org.apereo.cas.support.oauth.profile.OAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.profile.OAuth20UserProfileDataCreator;
import org.apereo.cas.support.oauth.services.OAuth20RegisteredServiceCipherExecutor;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20AuthorizationCodeResponseTypeAuthorizationRequestValidator;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20AuthorizationRequestValidator;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20IdTokenAndTokenResponseTypeAuthorizationRequestValidator;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20IdTokenResponseTypeAuthorizationRequestValidator;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20ProofKeyCodeExchangeResponseTypeAuthorizationRequestValidator;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20TokenResponseTypeAuthorizationRequestValidator;
import org.apereo.cas.support.oauth.validator.token.OAuth20AuthorizationCodeGrantTypeProofKeyCodeExchangeTokenRequestValidator;
import org.apereo.cas.support.oauth.validator.token.OAuth20AuthorizationCodeGrantTypeTokenRequestValidator;
import org.apereo.cas.support.oauth.validator.token.OAuth20ClientCredentialsGrantTypeTokenRequestValidator;
import org.apereo.cas.support.oauth.validator.token.OAuth20DeviceCodeResponseTypeRequestValidator;
import org.apereo.cas.support.oauth.validator.token.OAuth20PasswordGrantTypeTokenRequestValidator;
import org.apereo.cas.support.oauth.validator.token.OAuth20RefreshTokenGrantTypeTokenRequestValidator;
import org.apereo.cas.support.oauth.validator.token.OAuth20RevocationRequestValidator;
import org.apereo.cas.support.oauth.validator.token.OAuth20TokenRequestValidator;
import org.apereo.cas.support.oauth.web.OAuth20CasCallbackUrlResolver;
import org.apereo.cas.support.oauth.web.audit.OAuth20AccessTokenGrantRequestAuditResourceResolver;
import org.apereo.cas.support.oauth.web.audit.OAuth20AccessTokenResponseAuditResourceResolver;
import org.apereo.cas.support.oauth.web.audit.OAuth20CodeResponseAuditResourceResolver;
import org.apereo.cas.support.oauth.web.audit.OAuth20UserProfileDataAuditResourceResolver;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.response.OAuth20CasClientRedirectActionBuilder;
import org.apereo.cas.support.oauth.web.response.OAuth20DefaultCasClientRedirectActionBuilder;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20DefaultTokenGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenAuthorizationCodeGrantRequestExtractor;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenClientCredentialsGrantRequestExtractor;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenDeviceCodeResponseRequestExtractor;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenGrantAuditableRequestExtractor;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenGrantRequestExtractor;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenPasswordGrantRequestExtractor;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenProofKeyCodeExchangeAuthorizationCodeGrantRequestExtractor;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRefreshTokenGrantRequestExtractor;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20AccessTokenResponseGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20DefaultAccessTokenResponseGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20JwtAccessTokenCipherExecutor;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20RegisteredServiceJwtAccessTokenCipherExecutor;
import org.apereo.cas.support.oauth.web.response.callback.DefaultOAuth20AuthorizationModelAndViewBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationCodeAuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationModelAndViewBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20ClientCredentialsResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20InvalidAuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20ResourceOwnerCredentialsResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20TokenAuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.views.ConsentApprovalViewResolver;
import org.apereo.cas.support.oauth.web.views.OAuth20CallbackAuthorizeViewResolver;
import org.apereo.cas.support.oauth.web.views.OAuth20ConsentApprovalViewResolver;
import org.apereo.cas.support.oauth.web.views.OAuth20DefaultUserProfileViewRenderer;
import org.apereo.cas.support.oauth.web.views.OAuth20UserProfileViewRenderer;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TicketFactoryExecutionPlanConfigurer;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessTokenExpirationPolicyBuilder;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessTokenFactory;
import org.apereo.cas.ticket.accesstoken.OAuth20DefaultAccessTokenFactory;
import org.apereo.cas.ticket.accesstoken.OAuth20JwtBuilder;
import org.apereo.cas.ticket.code.OAuth20CodeExpirationPolicyBuilder;
import org.apereo.cas.ticket.code.OAuth20CodeFactory;
import org.apereo.cas.ticket.code.OAuth20DefaultOAuthCodeFactory;
import org.apereo.cas.ticket.device.OAuth20DefaultDeviceTokenFactory;
import org.apereo.cas.ticket.device.OAuth20DefaultDeviceUserCodeFactory;
import org.apereo.cas.ticket.device.OAuth20DeviceTokenExpirationPolicyBuilder;
import org.apereo.cas.ticket.device.OAuth20DeviceTokenFactory;
import org.apereo.cas.ticket.device.OAuth20DeviceUserCodeFactory;
import org.apereo.cas.ticket.refreshtoken.OAuth20DefaultRefreshTokenFactory;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshTokenExpirationPolicyBuilder;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshTokenFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.token.JwtBuilder;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.DefaultUniqueTicketIdGenerator;
import org.apereo.cas.util.HttpRequestUtils;
import org.apereo.cas.util.InternalTicketValidator;
import org.apereo.cas.util.cipher.CipherExecutorUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.validation.AuthenticationAttributeReleasePolicy;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.support.CookieUtils;
import org.apereo.inspektr.audit.spi.AuditActionResolver;
import org.apereo.inspektr.audit.spi.AuditResourceResolver;
import org.apereo.inspektr.audit.spi.support.DefaultAuditActionResolver;
import org.jasig.cas.client.validation.TicketValidator;
import org.pac4j.cas.client.CasClient;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.core.client.Client;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.JEESessionStore;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.credentials.extractor.BearerAuthExtractor;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.http.url.UrlResolver;
import org.pac4j.core.matching.matcher.Matcher;
import org.pac4j.core.matching.matcher.csrf.CsrfTokenGenerator;
import org.pac4j.core.matching.matcher.csrf.CsrfTokenGeneratorMatcher;
import org.pac4j.core.matching.matcher.csrf.DefaultCsrfTokenGenerator;
import org.pac4j.http.client.direct.DirectBasicAuthClient;
import org.pac4j.http.client.direct.DirectFormClient;
import org.pac4j.http.client.direct.HeaderClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

@Configuration(value="casOAuth20Configuration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasOAuth20Configuration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasOAuth20Configuration.class);
    @Autowired
    @Qualifier(value="authenticationAttributeReleasePolicy")
    private ObjectProvider<AuthenticationAttributeReleasePolicy> authenticationAttributeReleasePolicy;
    @Autowired
    @Qualifier(value="defaultPrincipalResolver")
    private ObjectProvider<PrincipalResolver> defaultPrincipalResolver;
    @Autowired
    @Qualifier(value="registeredServiceAccessStrategyEnforcer")
    private ObjectProvider<AuditableExecution> registeredServiceAccessStrategyEnforcer;
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private ObjectProvider<CentralAuthenticationService> centralAuthenticationService;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="webApplicationServiceFactory")
    private ObjectProvider<ServiceFactory<WebApplicationService>> webApplicationServiceFactory;
    @Autowired
    @Qualifier(value="defaultTicketFactory")
    private ObjectProvider<TicketFactory> ticketFactory;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private ObjectProvider<AuthenticationSystemSupport> authenticationSystemSupport;
    @Autowired
    @Qualifier(value="ticketRegistry")
    private ObjectProvider<TicketRegistry> ticketRegistry;
    @Autowired
    @Qualifier(value="ticketGrantingTicketCookieGenerator")
    private ObjectProvider<CasCookieBuilder> ticketGrantingTicketCookieGenerator;
    @Autowired
    @Qualifier(value="oauthDistributedSessionCookieGenerator")
    private ObjectProvider<CasCookieBuilder> oauthDistributedSessionCookieGenerator;

    @ConditionalOnMissingBean(name={"accessTokenResponseGenerator"})
    @Bean
    @RefreshScope
    public OAuth20AccessTokenResponseGenerator accessTokenResponseGenerator() {
        return new OAuth20DefaultAccessTokenResponseGenerator(this.accessTokenJwtBuilder(), this.casProperties);
    }

    @ConditionalOnMissingBean(name={"accessTokenJwtBuilder"})
    @Bean
    @RefreshScope
    public JwtBuilder accessTokenJwtBuilder() {
        return new OAuth20JwtBuilder(this.oauthAccessTokenJwtCipherExecutor(), (ServicesManager)this.servicesManager.getObject(), this.oauthRegisteredServiceJwtAccessTokenCipherExecutor());
    }

    @ConditionalOnMissingBean(name={"oauthRegisteredServiceJwtAccessTokenCipherExecutor"})
    @Bean
    @RefreshScope
    public RegisteredServiceCipherExecutor oauthRegisteredServiceJwtAccessTokenCipherExecutor() {
        return new OAuth20RegisteredServiceJwtAccessTokenCipherExecutor();
    }

    @ConditionalOnMissingBean(name={"oauthCasClientRedirectActionBuilder"})
    @Bean
    @RefreshScope
    public OAuth20CasClientRedirectActionBuilder oauthCasClientRedirectActionBuilder() {
        return new OAuth20DefaultCasClientRedirectActionBuilder();
    }

    @Bean
    @RefreshScope
    public UrlResolver casCallbackUrlResolver() {
        String callbackUrl = OAuth20Utils.casOAuthCallbackUrl((String)this.casProperties.getServer().getPrefix());
        return new OAuth20CasCallbackUrlResolver(callbackUrl);
    }

    @Bean
    @ConditionalOnMissingBean(name={"oauthSecConfig"})
    @RefreshScope
    public Config oauthSecConfig() {
        List<Client> clientList = this.oauthSecConfigClients();
        Config config = new Config(OAuth20Utils.casOAuthCallbackUrl((String)this.casProperties.getServer().getPrefix()), clientList);
        config.setSessionStore(this.oauthDistributedSessionStore());
        config.setMatcher(this.oauthSecCsrfTokenMatcher());
        Config.setProfileManagerFactory((String)"CASOAuthSecurityProfileManager", (webContext, sessionStore) -> new OAuth20ClientIdAwareProfileManager(webContext, config.getSessionStore(), (ServicesManager)this.servicesManager.getObject()));
        return config;
    }

    @Bean
    @ConditionalOnMissingBean(name={"oauthSecCsrfTokenMatcher"})
    @RefreshScope
    public Matcher oauthSecCsrfTokenMatcher() {
        CsrfTokenGeneratorMatcher csrfMatcher = new CsrfTokenGeneratorMatcher((CsrfTokenGenerator)new DefaultCsrfTokenGenerator());
        OAuthProperties oauth = this.casProperties.getAuthn().getOauth();
        CsrfCookieProperties csrfCookie = oauth.getCsrfCookie();
        int maxAge = csrfCookie.getMaxAge();
        if (maxAge >= 0) {
            csrfMatcher.setMaxAge(Integer.valueOf(maxAge));
        }
        csrfMatcher.setSameSitePolicy(csrfCookie.getSameSitePolicy());
        csrfMatcher.setDomain(csrfCookie.getDomain());
        csrfMatcher.setPath(csrfCookie.getPath());
        csrfMatcher.setHttpOnly(Boolean.valueOf(csrfCookie.isHttpOnly()));
        csrfMatcher.setSecure(Boolean.valueOf(csrfCookie.isSecure()));
        return csrfMatcher;
    }

    @Bean
    @ConditionalOnMissingBean(name={"oauthSecConfigClients"})
    @RefreshScope
    public List<Client> oauthSecConfigClients() {
        CasServerProperties server = this.casProperties.getServer();
        CasConfiguration cfg = new CasConfiguration(server.getLoginUrl());
        InternalTicketValidator validator = new InternalTicketValidator((CentralAuthenticationService)this.centralAuthenticationService.getObject(), (ServiceFactory)this.webApplicationServiceFactory.getObject(), (AuthenticationAttributeReleasePolicy)this.authenticationAttributeReleasePolicy.getObject(), (ServicesManager)this.servicesManager.getObject());
        cfg.setDefaultTicketValidator((TicketValidator)validator);
        CasClient oauthCasClient = new CasClient(cfg);
        oauthCasClient.setRedirectionActionBuilder((webContext, sessionStore) -> this.oauthCasClientRedirectActionBuilder().build(oauthCasClient, webContext));
        oauthCasClient.setName("CasOAuthClient");
        oauthCasClient.setUrlResolver(this.casCallbackUrlResolver());
        oauthCasClient.setCallbackUrl(OAuth20Utils.casOAuthCallbackUrl((String)server.getPrefix()));
        oauthCasClient.setCheckAuthenticationAttempt(false);
        oauthCasClient.init();
        Authenticator authenticator = this.oAuthClientAuthenticator();
        DirectBasicAuthClient basicAuthClient = new DirectBasicAuthClient(authenticator);
        basicAuthClient.setName("clientBasicAuth");
        basicAuthClient.init();
        DirectFormClient directFormClient = new DirectFormClient(authenticator);
        directFormClient.setName("clientForm");
        directFormClient.setUsernameParameter("client_id");
        directFormClient.setPasswordParameter("client_secret");
        directFormClient.init();
        Authenticator pkceAuthenticator = this.oAuthProofKeyCodeExchangeAuthenticator();
        DirectFormClient pkceAuthnFormClient = new DirectFormClient(pkceAuthenticator);
        pkceAuthnFormClient.setName("pkceFormAuthn");
        pkceAuthnFormClient.setUsernameParameter("client_id");
        pkceAuthnFormClient.setPasswordParameter("code_verifier");
        pkceAuthnFormClient.init();
        DirectBasicAuthClient pkceBasicAuthClient = new DirectBasicAuthClient(pkceAuthenticator);
        pkceBasicAuthClient.setName("pkceBasicAuthn");
        pkceBasicAuthClient.init();
        DirectFormClient refreshTokenFormClient = new DirectFormClient(this.oAuthRefreshTokenAuthenticator());
        refreshTokenFormClient.setName("clientRefreshTokenFormAuth");
        refreshTokenFormClient.setUsernameParameter("client_id");
        refreshTokenFormClient.setPasswordParameter("refresh_token");
        refreshTokenFormClient.init();
        DirectFormClient userFormClient = new DirectFormClient(this.oAuthUserAuthenticator());
        userFormClient.setName("userForm");
        userFormClient.init();
        HeaderClient accessTokenClient = new HeaderClient();
        accessTokenClient.setCredentialsExtractor((CredentialsExtractor)new BearerAuthExtractor());
        accessTokenClient.setAuthenticator(this.oAuthAccessTokenAuthenticator());
        accessTokenClient.setName("clientAccessTokenAuth");
        accessTokenClient.init();
        ArrayList<Client> clientList = new ArrayList<Client>();
        Map beans = this.applicationContext.getBeansOfType(OAuth20AuthenticationClientProvider.class, false, true);
        ArrayList providers = new ArrayList(beans.values());
        AnnotationAwareOrderComparator.sort(providers);
        providers.forEach(p -> clientList.add(p.createClient()));
        clientList.add((Client)oauthCasClient);
        clientList.add((Client)basicAuthClient);
        clientList.add((Client)pkceAuthnFormClient);
        clientList.add((Client)pkceBasicAuthClient);
        clientList.add((Client)refreshTokenFormClient);
        clientList.add((Client)directFormClient);
        clientList.add((Client)userFormClient);
        clientList.add((Client)accessTokenClient);
        return clientList;
    }

    @ConditionalOnMissingBean(name={"consentApprovalViewResolver"})
    @Bean
    @RefreshScope
    public ConsentApprovalViewResolver consentApprovalViewResolver() {
        return new OAuth20ConsentApprovalViewResolver(this.casProperties, this.oauthDistributedSessionStore());
    }

    @ConditionalOnMissingBean(name={"callbackAuthorizeViewResolver"})
    @Bean
    public OAuth20CallbackAuthorizeViewResolver callbackAuthorizeViewResolver() {
        return new OAuth20CallbackAuthorizeViewResolver(){};
    }

    @ConditionalOnMissingBean(name={"oAuthClientAuthenticator"})
    @Bean
    @RefreshScope
    public Authenticator oAuthClientAuthenticator() {
        return new OAuth20ClientIdClientSecretAuthenticator((ServicesManager)this.servicesManager.getObject(), (ServiceFactory)this.webApplicationServiceFactory.getObject(), (AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getObject(), this.oauthRegisteredServiceCipherExecutor(), (TicketRegistry)this.ticketRegistry.getObject(), (PrincipalResolver)this.defaultPrincipalResolver.getObject());
    }

    @ConditionalOnMissingBean(name={"oAuthProofKeyCodeExchangeAuthenticator"})
    @Bean
    @RefreshScope
    public Authenticator oAuthProofKeyCodeExchangeAuthenticator() {
        return new OAuth20ProofKeyCodeExchangeAuthenticator((ServicesManager)this.servicesManager.getObject(), (ServiceFactory)this.webApplicationServiceFactory.getObject(), (AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getObject(), (TicketRegistry)this.ticketRegistry.getObject(), this.oauthRegisteredServiceCipherExecutor(), (PrincipalResolver)this.defaultPrincipalResolver.getObject());
    }

    @ConditionalOnMissingBean(name={"oAuthRefreshTokenAuthenticator"})
    @Bean
    @RefreshScope
    public Authenticator oAuthRefreshTokenAuthenticator() {
        return new OAuth20RefreshTokenAuthenticator((ServicesManager)this.servicesManager.getObject(), (ServiceFactory)this.webApplicationServiceFactory.getObject(), (AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getObject(), (TicketRegistry)this.ticketRegistry.getObject(), this.oauthRegisteredServiceCipherExecutor(), (PrincipalResolver)this.defaultPrincipalResolver.getObject());
    }

    @ConditionalOnMissingBean(name={"oAuthUserAuthenticator"})
    @Bean
    @RefreshScope
    public Authenticator oAuthUserAuthenticator() {
        return new OAuth20UsernamePasswordAuthenticator((AuthenticationSystemSupport)this.authenticationSystemSupport.getObject(), (ServicesManager)this.servicesManager.getObject(), (ServiceFactory)this.webApplicationServiceFactory.getObject(), this.oauthRegisteredServiceCipherExecutor(), this.oauthDistributedSessionStore());
    }

    @ConditionalOnMissingBean(name={"oAuthAccessTokenAuthenticator"})
    @Bean
    @RefreshScope
    public Authenticator oAuthAccessTokenAuthenticator() {
        return new OAuth20AccessTokenAuthenticator((TicketRegistry)this.ticketRegistry.getObject(), this.accessTokenJwtBuilder());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"defaultAccessTokenFactory"})
    public OAuth20AccessTokenFactory defaultAccessTokenFactory() {
        return new OAuth20DefaultAccessTokenFactory(this.accessTokenIdGenerator(), this.accessTokenExpirationPolicy(), this.accessTokenJwtBuilder(), (ServicesManager)this.servicesManager.getObject());
    }

    @ConditionalOnMissingBean(name={"defaultAccessTokenFactoryConfigurer"})
    @Bean
    @RefreshScope
    public TicketFactoryExecutionPlanConfigurer defaultAccessTokenFactoryConfigurer() {
        return this::defaultAccessTokenFactory;
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"defaultDeviceTokenFactory"})
    public OAuth20DeviceTokenFactory defaultDeviceTokenFactory() {
        return new OAuth20DefaultDeviceTokenFactory(this.deviceTokenIdGenerator(), this.deviceTokenExpirationPolicy(), this.casProperties.getAuthn().getOauth().getDeviceUserCode().getUserCodeLength(), (ServicesManager)this.servicesManager.getObject());
    }

    @ConditionalOnMissingBean(name={"defaultDeviceTokenFactoryConfigurer"})
    @Bean
    @RefreshScope
    public TicketFactoryExecutionPlanConfigurer defaultDeviceTokenFactoryConfigurer() {
        return this::defaultDeviceTokenFactory;
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"defaultDeviceUserCodeFactory"})
    public OAuth20DeviceUserCodeFactory defaultDeviceUserCodeFactory() {
        return new OAuth20DefaultDeviceUserCodeFactory(this.deviceTokenIdGenerator(), this.deviceTokenExpirationPolicy(), this.casProperties.getAuthn().getOauth().getDeviceUserCode().getUserCodeLength(), (ServicesManager)this.servicesManager.getObject());
    }

    @ConditionalOnMissingBean(name={"defaultDeviceUserCodeFactoryConfigurer"})
    @Bean
    @RefreshScope
    public TicketFactoryExecutionPlanConfigurer defaultDeviceUserCodeFactoryConfigurer() {
        return this::defaultDeviceUserCodeFactory;
    }

    @Bean
    @ConditionalOnMissingBean(name={"accessTokenExpirationPolicy"})
    @RefreshScope
    public ExpirationPolicyBuilder accessTokenExpirationPolicy() {
        return new OAuth20AccessTokenExpirationPolicyBuilder(this.casProperties);
    }

    @Bean
    @ConditionalOnMissingBean(name={"deviceTokenExpirationPolicy"})
    @RefreshScope
    public ExpirationPolicyBuilder deviceTokenExpirationPolicy() {
        return new OAuth20DeviceTokenExpirationPolicyBuilder(this.casProperties);
    }

    @Bean
    @RefreshScope
    public ExpirationPolicyBuilder oAuthCodeExpirationPolicy() {
        return new OAuth20CodeExpirationPolicyBuilder(this.casProperties);
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"oAuthCodeIdGenerator"})
    public UniqueTicketIdGenerator oAuthCodeIdGenerator() {
        return new DefaultUniqueTicketIdGenerator();
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"refreshTokenIdGenerator"})
    public UniqueTicketIdGenerator refreshTokenIdGenerator() {
        return new DefaultUniqueTicketIdGenerator();
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"defaultOAuthCodeFactory"})
    public OAuth20CodeFactory defaultOAuthCodeFactory() {
        return new OAuth20DefaultOAuthCodeFactory(this.oAuthCodeIdGenerator(), this.oAuthCodeExpirationPolicy(), (ServicesManager)this.servicesManager.getObject());
    }

    @ConditionalOnMissingBean(name={"defaultOAuthCodeFactoryConfigurer"})
    @Bean
    @RefreshScope
    public TicketFactoryExecutionPlanConfigurer defaultOAuthCodeFactoryConfigurer() {
        return this::defaultOAuthCodeFactory;
    }

    @ConditionalOnMissingBean(name={"profileScopeToAttributesFilter"})
    @Bean
    public OAuth20ProfileScopeToAttributesFilter profileScopeToAttributesFilter() {
        return new DefaultOAuth20ProfileScopeToAttributesFilter();
    }

    @ConditionalOnMissingBean(name={"oauthTokenGenerator"})
    @Bean
    @RefreshScope
    public OAuth20TokenGenerator oauthTokenGenerator() {
        return new OAuth20DefaultTokenGenerator(this.defaultAccessTokenFactory(), this.defaultDeviceTokenFactory(), this.defaultDeviceUserCodeFactory(), this.defaultRefreshTokenFactory(), (CentralAuthenticationService)this.centralAuthenticationService.getObject(), this.casProperties);
    }

    @Bean
    public Collection<AccessTokenGrantRequestExtractor> accessTokenGrantRequestExtractors() {
        OAuth20ConfigurationContext context = this.oauth20ConfigurationContext();
        AccessTokenProofKeyCodeExchangeAuthorizationCodeGrantRequestExtractor pkceExt = new AccessTokenProofKeyCodeExchangeAuthorizationCodeGrantRequestExtractor(context);
        AccessTokenAuthorizationCodeGrantRequestExtractor authzCodeExt = new AccessTokenAuthorizationCodeGrantRequestExtractor(context);
        AccessTokenRefreshTokenGrantRequestExtractor refreshTokenExt = new AccessTokenRefreshTokenGrantRequestExtractor(context);
        AccessTokenPasswordGrantRequestExtractor pswExt = new AccessTokenPasswordGrantRequestExtractor(context);
        AccessTokenClientCredentialsGrantRequestExtractor credsExt = new AccessTokenClientCredentialsGrantRequestExtractor(context);
        AccessTokenDeviceCodeResponseRequestExtractor deviceCodeExt = new AccessTokenDeviceCodeResponseRequestExtractor(context);
        return CollectionUtils.wrapList((Object[])new AccessTokenGrantRequestExtractor[]{pkceExt, authzCodeExt, refreshTokenExt, deviceCodeExt, pswExt, credsExt});
    }

    @ConditionalOnMissingBean(name={"accessTokenGrantAuditableRequestExtractor"})
    @Bean
    @RefreshScope
    public AuditableExecution accessTokenGrantAuditableRequestExtractor() {
        return new AccessTokenGrantAuditableRequestExtractor(this.accessTokenGrantRequestExtractors());
    }

    @ConditionalOnMissingBean(name={"oauthUserProfileViewRenderer"})
    @Bean
    @RefreshScope
    public OAuth20UserProfileViewRenderer oauthUserProfileViewRenderer() {
        return new OAuth20DefaultUserProfileViewRenderer(this.casProperties.getAuthn().getOauth());
    }

    @ConditionalOnMissingBean(name={"oAuth2UserProfileDataCreator"})
    @Bean
    @RefreshScope
    public OAuth20UserProfileDataCreator oAuth2UserProfileDataCreator() {
        return new DefaultOAuth20UserProfileDataCreator((ServicesManager)this.servicesManager.getObject(), this.profileScopeToAttributesFilter());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"oauthAuthorizationModelAndViewBuilder"})
    public OAuth20AuthorizationModelAndViewBuilder oauthAuthorizationModelAndViewBuilder() {
        return new DefaultOAuth20AuthorizationModelAndViewBuilder();
    }

    @ConditionalOnMissingBean(name={"oauthAuthorizationResponseBuilders"})
    @Bean
    @RefreshScope
    public Set<OAuth20AuthorizationResponseBuilder> oauthAuthorizationResponseBuilders() {
        LinkedHashSet<OAuth20AuthorizationResponseBuilder> builders = new LinkedHashSet<OAuth20AuthorizationResponseBuilder>(2);
        builders.add(this.oauthAuthorizationCodeResponseBuilder());
        builders.add(this.oauthTokenResponseBuilder());
        return builders;
    }

    @ConditionalOnMissingBean(name={"oauthAuthorizationRequestValidators"})
    @Bean
    @RefreshScope
    public Set<OAuth20AuthorizationRequestValidator> oauthAuthorizationRequestValidators() {
        LinkedHashSet<OAuth20AuthorizationRequestValidator> validators = new LinkedHashSet<OAuth20AuthorizationRequestValidator>(6);
        validators.add(this.oauthProofKeyCodeExchangeResponseTypeAuthorizationRequestValidator());
        validators.add(this.oauthAuthorizationCodeResponseTypeRequestValidator());
        validators.add(this.oauthIdTokenResponseTypeRequestValidator());
        validators.add(this.oauthTokenResponseTypeRequestValidator());
        validators.add(this.oauthIdTokenAndTokenResponseTypeRequestValidator());
        return validators;
    }

    @Bean
    @ConditionalOnMissingBean(name={"oauth20AuthorizationCodeGrantTypeProofKeyCodeExchangeTokenRequestValidator"})
    @RefreshScope
    public OAuth20TokenRequestValidator oauth20AuthorizationCodeGrantTypeProofKeyCodeExchangeTokenRequestValidator() {
        OAuth20ConfigurationContext context = this.oauth20ConfigurationContext();
        return new OAuth20AuthorizationCodeGrantTypeProofKeyCodeExchangeTokenRequestValidator(context);
    }

    @Bean
    @ConditionalOnMissingBean(name={"oauthAuthorizationCodeGrantTypeTokenRequestValidator"})
    @RefreshScope
    public OAuth20TokenRequestValidator oauthAuthorizationCodeGrantTypeTokenRequestValidator() {
        OAuth20ConfigurationContext context = this.oauth20ConfigurationContext();
        return new OAuth20AuthorizationCodeGrantTypeTokenRequestValidator(context);
    }

    @Bean
    @ConditionalOnMissingBean(name={"oauthDeviceCodeResponseTypeRequestValidator"})
    @RefreshScope
    public OAuth20TokenRequestValidator oauthDeviceCodeResponseTypeRequestValidator() {
        ServicesManager svcManager = (ServicesManager)this.servicesManager.getObject();
        return new OAuth20DeviceCodeResponseTypeRequestValidator(svcManager, (ServiceFactory)this.webApplicationServiceFactory.getObject());
    }

    @Bean
    @ConditionalOnMissingBean(name={"oauthRevocationRequestValidator"})
    @RefreshScope
    public OAuth20TokenRequestValidator oauthRevocationRequestValidator() {
        ServicesManager svcManager = (ServicesManager)this.servicesManager.getObject();
        return new OAuth20RevocationRequestValidator(svcManager, this.oauthDistributedSessionStore());
    }

    @Bean
    @ConditionalOnMissingBean(name={"oauthRefreshTokenGrantTypeTokenRequestValidator"})
    @RefreshScope
    public OAuth20TokenRequestValidator oauthRefreshTokenGrantTypeTokenRequestValidator() {
        OAuth20ConfigurationContext context = this.oauth20ConfigurationContext();
        return new OAuth20RefreshTokenGrantTypeTokenRequestValidator(context);
    }

    @Bean
    @ConditionalOnMissingBean(name={"oauthPasswordGrantTypeTokenRequestValidator"})
    @RefreshScope
    public OAuth20TokenRequestValidator oauthPasswordGrantTypeTokenRequestValidator() {
        OAuth20ConfigurationContext context = this.oauth20ConfigurationContext();
        return new OAuth20PasswordGrantTypeTokenRequestValidator(context);
    }

    @Bean
    @ConditionalOnMissingBean(name={"oauthClientCredentialsGrantTypeTokenRequestValidator"})
    @RefreshScope
    public OAuth20TokenRequestValidator oauthClientCredentialsGrantTypeTokenRequestValidator() {
        OAuth20ConfigurationContext context = this.oauth20ConfigurationContext();
        return new OAuth20ClientCredentialsGrantTypeTokenRequestValidator(context);
    }

    @ConditionalOnMissingBean(name={"oauthTokenRequestValidators"})
    @Bean
    @RefreshScope
    public Collection<OAuth20TokenRequestValidator> oauthTokenRequestValidators() {
        ArrayList<OAuth20TokenRequestValidator> validators = new ArrayList<OAuth20TokenRequestValidator>(6);
        validators.add(this.oauth20AuthorizationCodeGrantTypeProofKeyCodeExchangeTokenRequestValidator());
        validators.add(this.oauthAuthorizationCodeGrantTypeTokenRequestValidator());
        validators.add(this.oauthDeviceCodeResponseTypeRequestValidator());
        validators.add(this.oauthRefreshTokenGrantTypeTokenRequestValidator());
        validators.add(this.oauthPasswordGrantTypeTokenRequestValidator());
        validators.add(this.oauthClientCredentialsGrantTypeTokenRequestValidator());
        validators.add(this.oauthRevocationRequestValidator());
        return validators;
    }

    @ConditionalOnMissingBean(name={"oauthAuthorizationCodeResponseTypeRequestValidator"})
    @Bean
    @RefreshScope
    public OAuth20AuthorizationRequestValidator oauthAuthorizationCodeResponseTypeRequestValidator() {
        return new OAuth20AuthorizationCodeResponseTypeAuthorizationRequestValidator((ServicesManager)this.servicesManager.getObject(), (ServiceFactory)this.webApplicationServiceFactory.getObject(), (AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getObject());
    }

    @ConditionalOnMissingBean(name={"oauthProofKeyCodeExchangeResponseTypeAuthorizationRequestValidator"})
    @Bean
    @RefreshScope
    public OAuth20AuthorizationRequestValidator oauthProofKeyCodeExchangeResponseTypeAuthorizationRequestValidator() {
        return new OAuth20ProofKeyCodeExchangeResponseTypeAuthorizationRequestValidator((ServicesManager)this.servicesManager.getObject(), (ServiceFactory)this.webApplicationServiceFactory.getObject(), (AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getObject());
    }

    @ConditionalOnMissingBean(name={"oauthTokenResponseTypeRequestValidator"})
    @Bean
    @RefreshScope
    public OAuth20AuthorizationRequestValidator oauthTokenResponseTypeRequestValidator() {
        return new OAuth20TokenResponseTypeAuthorizationRequestValidator((ServicesManager)this.servicesManager.getObject(), (ServiceFactory)this.webApplicationServiceFactory.getObject(), (AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getObject());
    }

    @ConditionalOnMissingBean(name={"oauthIdTokenResponseTypeRequestValidator"})
    @Bean
    @RefreshScope
    public OAuth20AuthorizationRequestValidator oauthIdTokenResponseTypeRequestValidator() {
        return new OAuth20IdTokenResponseTypeAuthorizationRequestValidator((ServicesManager)this.servicesManager.getObject(), (ServiceFactory)this.webApplicationServiceFactory.getObject(), (AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getObject());
    }

    @ConditionalOnMissingBean(name={"oauthIdTokenAndTokenResponseTypeRequestValidator"})
    @Bean
    @RefreshScope
    public OAuth20AuthorizationRequestValidator oauthIdTokenAndTokenResponseTypeRequestValidator() {
        return new OAuth20IdTokenAndTokenResponseTypeAuthorizationRequestValidator((ServicesManager)this.servicesManager.getObject(), (ServiceFactory)this.webApplicationServiceFactory.getObject(), (AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getObject());
    }

    @ConditionalOnMissingBean(name={"oauthResourceOwnerCredentialsResponseBuilder"})
    @Bean
    @RefreshScope
    public OAuth20AuthorizationResponseBuilder oauthResourceOwnerCredentialsResponseBuilder() {
        return new OAuth20ResourceOwnerCredentialsResponseBuilder((ServicesManager)this.servicesManager.getObject(), this.casProperties, this.accessTokenResponseGenerator(), this.oauthTokenGenerator(), this.oauthAuthorizationModelAndViewBuilder());
    }

    @ConditionalOnMissingBean(name={"oauthClientCredentialsResponseBuilder"})
    @Bean
    @RefreshScope
    public OAuth20AuthorizationResponseBuilder oauthClientCredentialsResponseBuilder() {
        return new OAuth20ClientCredentialsResponseBuilder((ServicesManager)this.servicesManager.getObject(), this.accessTokenResponseGenerator(), this.oauthTokenGenerator(), this.casProperties, this.oauthAuthorizationModelAndViewBuilder());
    }

    @ConditionalOnMissingBean(name={"oauthTokenResponseBuilder"})
    @Bean
    @RefreshScope
    public OAuth20AuthorizationResponseBuilder oauthTokenResponseBuilder() {
        return new OAuth20TokenAuthorizationResponseBuilder((ServicesManager)this.servicesManager.getObject(), this.casProperties, this.oauthTokenGenerator(), this.accessTokenJwtBuilder(), this.oauthAuthorizationModelAndViewBuilder());
    }

    @ConditionalOnMissingBean(name={"oauthAuthorizationCodeResponseBuilder"})
    @Bean
    @RefreshScope
    public OAuth20AuthorizationResponseBuilder oauthAuthorizationCodeResponseBuilder() {
        return new OAuth20AuthorizationCodeAuthorizationResponseBuilder((ServicesManager)this.servicesManager.getObject(), this.casProperties, (TicketRegistry)this.ticketRegistry.getObject(), this.defaultOAuthCodeFactory(), this.oauthAuthorizationModelAndViewBuilder());
    }

    @ConditionalOnMissingBean(name={"oauthInvalidAuthorizationBuilder"})
    @Bean
    @RefreshScope
    public OAuth20InvalidAuthorizationResponseBuilder oauthInvalidAuthorizationBuilder() {
        return new OAuth20InvalidAuthorizationResponseBuilder((ServicesManager)this.servicesManager.getObject());
    }

    @ConditionalOnMissingBean(name={"oauthPrincipalFactory"})
    @Bean
    @RefreshScope
    public PrincipalFactory oauthPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"defaultRefreshTokenFactory"})
    public OAuth20RefreshTokenFactory defaultRefreshTokenFactory() {
        return new OAuth20DefaultRefreshTokenFactory(this.refreshTokenIdGenerator(), this.refreshTokenExpirationPolicy(), (ServicesManager)this.servicesManager.getObject());
    }

    @ConditionalOnMissingBean(name={"defaultRefreshTokenFactoryConfigurer"})
    @Bean
    @RefreshScope
    public TicketFactoryExecutionPlanConfigurer defaultRefreshTokenFactoryConfigurer() {
        return this::defaultRefreshTokenFactory;
    }

    @Bean
    @RefreshScope
    public ExpirationPolicyBuilder refreshTokenExpirationPolicy() {
        return new OAuth20RefreshTokenExpirationPolicyBuilder(this.casProperties);
    }

    @ConditionalOnMissingBean(name={"oauthCasAuthenticationBuilder"})
    @Bean
    @RefreshScope
    public OAuth20CasAuthenticationBuilder oauthCasAuthenticationBuilder() {
        return new OAuth20DefaultCasAuthenticationBuilder(this.oauthPrincipalFactory(), (ServiceFactory)this.webApplicationServiceFactory.getObject(), this.profileScopeToAttributesFilter(), this.casProperties);
    }

    @ConditionalOnMissingBean(name={"accessTokenIdGenerator"})
    @Bean
    @RefreshScope
    public UniqueTicketIdGenerator accessTokenIdGenerator() {
        return new DefaultUniqueTicketIdGenerator();
    }

    @ConditionalOnMissingBean(name={"deviceTokenIdGenerator"})
    @Bean
    @RefreshScope
    public UniqueTicketIdGenerator deviceTokenIdGenerator() {
        return new DefaultUniqueTicketIdGenerator();
    }

    @Bean
    @ConditionalOnMissingBean(name={"oauthAuditTrailRecordResolutionPlanConfigurer"})
    public AuditTrailRecordResolutionPlanConfigurer oauthAuditTrailRecordResolutionPlanConfigurer() {
        return plan -> {
            plan.registerAuditActionResolver("OAUTH2_USER_PROFILE_ACTION_RESOLVER", (AuditActionResolver)new DefaultAuditActionResolver("_CREATED", "_CREATED"));
            plan.registerAuditResourceResolver("OAUTH2_USER_PROFILE_RESOURCE_RESOLVER", (AuditResourceResolver)new OAuth20UserProfileDataAuditResourceResolver());
            plan.registerAuditActionResolver("OAUTH2_ACCESS_TOKEN_REQUEST_ACTION_RESOLVER", (AuditActionResolver)new DefaultAuditActionResolver("_CREATED", "_CREATED"));
            plan.registerAuditResourceResolver("OAUTH2_ACCESS_TOKEN_REQUEST_RESOURCE_RESOLVER", (AuditResourceResolver)new OAuth20AccessTokenGrantRequestAuditResourceResolver());
            plan.registerAuditActionResolver("OAUTH2_ACCESS_TOKEN_RESPONSE_ACTION_RESOLVER", (AuditActionResolver)new DefaultAuditActionResolver("_CREATED", "_CREATED"));
            plan.registerAuditResourceResolver("OAUTH2_ACCESS_TOKEN_RESPONSE_RESOURCE_RESOLVER", (AuditResourceResolver)new OAuth20AccessTokenResponseAuditResourceResolver());
            plan.registerAuditActionResolver("OAUTH2_CODE_RESPONSE_ACTION_RESOLVER", (AuditActionResolver)new DefaultAuditActionResolver("_CREATED", "_CREATED"));
            plan.registerAuditResourceResolver("OAUTH2_CODE_RESPONSE_RESOURCE_RESOLVER", (AuditResourceResolver)new OAuth20CodeResponseAuditResourceResolver());
        };
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"oauthAccessTokenJwtCipherExecutor"})
    public CipherExecutor oauthAccessTokenJwtCipherExecutor() {
        EncryptionOptionalSigningOptionalJwtCryptographyProperties crypto = this.casProperties.getAuthn().getOauth().getAccessToken().getCrypto();
        boolean bl = !crypto.isEnabled() && StringUtils.isNotBlank((CharSequence)crypto.getEncryption().getKey()) && StringUtils.isNotBlank((CharSequence)crypto.getSigning().getKey());
        Boolean enabled = (Boolean)FunctionUtils.doIf((boolean)bl, () -> {
            LOGGER.warn("Default encryption/signing is not enabled explicitly for OAuth access tokens as JWTs if necessary, yet signing/encryption keys are defined for operations. CAS will proceed to enable the token encryption/signing functionality.");
            return Boolean.TRUE;
        }, () -> ((EncryptionOptionalSigningOptionalJwtCryptographyProperties)crypto).isEnabled()).get();
        if (enabled.booleanValue()) {
            return CipherExecutorUtils.newStringCipherExecutor((EncryptionOptionalSigningOptionalJwtCryptographyProperties)crypto, OAuth20JwtAccessTokenCipherExecutor.class);
        }
        LOGGER.info("OAuth access token encryption/signing is turned off for JWTs, if/when needed. This MAY NOT be safe in a production environment.");
        return CipherExecutor.noOp();
    }

    @ConditionalOnMissingBean(name={"oauthDistributedSessionCookieGenerator"})
    @Bean
    public CasCookieBuilder oauthDistributedSessionCookieGenerator() {
        CookieSessionReplicationProperties cookie = this.casProperties.getSessionReplication().getCookie();
        return CookieUtils.buildCookieRetrievingGenerator((CookieProperties)cookie);
    }

    @ConditionalOnMissingBean(name={"oauthDistributedSessionStore"})
    @Bean
    public SessionStore oauthDistributedSessionStore() {
        boolean replicate = this.casProperties.getAuthn().getOauth().isReplicateSessions();
        if (replicate) {
            return new DistributedJEESessionStore((CentralAuthenticationService)this.centralAuthenticationService.getObject(), (TicketFactory)this.ticketFactory.getObject(), this.oauthDistributedSessionCookieGenerator());
        }
        return JEESessionStore.INSTANCE;
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"oauthLogoutExecutionPlanConfigurer"})
    public LogoutExecutionPlanConfigurer oauthLogoutExecutionPlanConfigurer() {
        return plan -> {
            boolean replicate = this.casProperties.getAuthn().getOauth().isReplicateSessions();
            if (replicate) {
                plan.registerLogoutPostProcessor(ticketGrantingTicket -> {
                    HttpServletRequest request = HttpRequestUtils.getHttpServletRequestFromRequestAttributes();
                    HttpServletResponse response = HttpRequestUtils.getHttpServletResponseFromRequestAttributes();
                    if (request != null && response != null) {
                        SessionStore store = this.oauthDistributedSessionStore();
                        store.destroySession((WebContext)new JEEContext(request, response));
                    }
                });
            }
        };
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"oauthRegisteredServiceCipherExecutor"})
    public CipherExecutor oauthRegisteredServiceCipherExecutor() {
        EncryptionOptionalSigningOptionalJwtCryptographyProperties crypto = this.casProperties.getAuthn().getOauth().getCrypto();
        boolean bl = !crypto.isEnabled() && StringUtils.isNotBlank((CharSequence)crypto.getEncryption().getKey()) && StringUtils.isNotBlank((CharSequence)crypto.getSigning().getKey());
        Boolean enabled = (Boolean)FunctionUtils.doIf((boolean)bl, () -> {
            LOGGER.warn("Secret encryption/signing is not enabled explicitly in the configuration for OAuth/OIDC services, yet signing/encryption keys are defined for operations. CAS will proceed to enable the encryption/signing functionality.");
            return Boolean.TRUE;
        }, () -> ((EncryptionOptionalSigningOptionalJwtCryptographyProperties)crypto).isEnabled()).get();
        if (enabled.booleanValue()) {
            return CipherExecutorUtils.newStringCipherExecutor((EncryptionOptionalSigningOptionalJwtCryptographyProperties)crypto, OAuth20RegisteredServiceCipherExecutor.class);
        }
        LOGGER.info("Relying party secret encryption/signing is turned off for OAuth/OIDC services. This MAY NOT be safe in a production environment. Consider using other choices to handle encryption, signing and verification of relying party secrets.");
        return CipherExecutor.noOp();
    }

    @Bean
    @Scope(value="prototype")
    public OAuth20ConfigurationContext oauth20ConfigurationContext() {
        return OAuth20ConfigurationContext.builder().applicationContext(this.applicationContext).registeredServiceCipherExecutor(this.oauthRegisteredServiceCipherExecutor()).sessionStore(this.oauthDistributedSessionStore()).servicesManager((ServicesManager)this.servicesManager.getObject()).ticketRegistry((TicketRegistry)this.ticketRegistry.getObject()).accessTokenFactory(this.defaultAccessTokenFactory()).deviceTokenFactory(this.defaultDeviceTokenFactory()).deviceUserCodeFactory(this.defaultDeviceUserCodeFactory()).principalFactory(this.oauthPrincipalFactory()).webApplicationServiceServiceFactory((ServiceFactory)this.webApplicationServiceFactory.getObject()).casProperties(this.casProperties).ticketGrantingTicketCookieGenerator((CasCookieBuilder)this.ticketGrantingTicketCookieGenerator.getObject()).oauthDistributedSessionCookieGenerator((CasCookieBuilder)this.oauthDistributedSessionCookieGenerator.getObject()).oauthConfig(this.oauthSecConfig()).registeredServiceAccessStrategyEnforcer((AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getObject()).centralAuthenticationService((CentralAuthenticationService)this.centralAuthenticationService.getObject()).callbackAuthorizeViewResolver(this.callbackAuthorizeViewResolver()).profileScopeToAttributesFilter(this.profileScopeToAttributesFilter()).accessTokenGenerator(this.oauthTokenGenerator()).accessTokenJwtBuilder(this.accessTokenJwtBuilder()).accessTokenResponseGenerator(this.accessTokenResponseGenerator()).deviceTokenExpirationPolicy(this.deviceTokenExpirationPolicy()).accessTokenGrantRequestValidators(this.oauthTokenRequestValidators()).userProfileDataCreator(this.oAuth2UserProfileDataCreator()).userProfileViewRenderer(this.oauthUserProfileViewRenderer()).oAuthCodeFactory(this.defaultOAuthCodeFactory()).consentApprovalViewResolver(this.consentApprovalViewResolver()).authenticationBuilder(this.oauthCasAuthenticationBuilder()).oauthAuthorizationResponseBuilders(this.oauthAuthorizationResponseBuilders()).oauthInvalidAuthorizationResponseBuilder(this.oauthInvalidAuthorizationBuilder()).oauthRequestValidators(this.oauthAuthorizationRequestValidators()).build();
    }
}

