/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20AuthorizationRequestValidator;
import org.apereo.cas.support.oauth.web.OAuth20HandlerInterceptorAdapter;
import org.apereo.cas.support.oauth.web.OAuth20TicketGrantingTicketAwareSecurityLogic;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenGrantRequestExtractor;
import org.apereo.cas.throttle.AuthenticationThrottlingExecutionPlan;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.DirectClient;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.engine.DefaultSecurityLogic;
import org.pac4j.core.engine.SecurityGrantedAccessAdapter;
import org.pac4j.core.engine.SecurityLogic;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.http.adapter.JEEHttpActionAdapter;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.springframework.web.SecurityInterceptor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(value="casOAuth20ThrottleConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasOAuth20ThrottleConfiguration {
    @Autowired
    @Qualifier(value="oauthSecConfig")
    private ObjectProvider<Config> oauthSecConfig;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="accessTokenGrantRequestExtractors")
    private Collection<AccessTokenGrantRequestExtractor> accessTokenGrantRequestExtractors;
    @Autowired
    @Qualifier(value="oauthAuthorizationRequestValidators")
    private Set<OAuth20AuthorizationRequestValidator> oauthAuthorizationRequestValidators;
    @Autowired
    @Qualifier(value="authenticationThrottlingExecutionPlan")
    private ObjectProvider<AuthenticationThrottlingExecutionPlan> authenticationThrottlingExecutionPlan;
    @Autowired
    @Qualifier(value="ticketGrantingTicketCookieGenerator")
    private ObjectProvider<CasCookieBuilder> ticketGrantingTicketCookieGenerator;
    @Autowired
    @Qualifier(value="ticketRegistry")
    private ObjectProvider<TicketRegistry> ticketRegistry;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private ObjectProvider<CentralAuthenticationService> centralAuthenticationService;

    @ConditionalOnMissingBean(name={"requiresAuthenticationAuthorizeInterceptor"})
    @Bean
    public HandlerInterceptor requiresAuthenticationAuthorizeInterceptor() {
        SecurityInterceptor interceptor = new SecurityInterceptor((Config)this.oauthSecConfig.getObject(), "CasOAuthClient", (HttpActionAdapter)JEEHttpActionAdapter.INSTANCE);
        interceptor.setMatchers("securityheaders");
        interceptor.setAuthorizers("isFullyAuthenticated");
        OAuth20TicketGrantingTicketAwareSecurityLogic logic = new OAuth20TicketGrantingTicketAwareSecurityLogic((CasCookieBuilder)this.ticketGrantingTicketCookieGenerator.getObject(), (TicketRegistry)this.ticketRegistry.getObject(), (CentralAuthenticationService)this.centralAuthenticationService.getObject());
        interceptor.setSecurityLogic((SecurityLogic)logic);
        return interceptor;
    }

    @ConditionalOnMissingBean(name={"requiresAuthenticationAccessTokenInterceptor"})
    @Bean
    public HandlerInterceptor requiresAuthenticationAccessTokenInterceptor() {
        Config secConfig = (Config)this.oauthSecConfig.getObject();
        String clients = Objects.requireNonNull(secConfig).getClients().findAllClients().stream().filter(client -> client instanceof DirectClient).map(Client::getName).collect(Collectors.joining(","));
        SecurityInterceptor interceptor = new SecurityInterceptor((Config)this.oauthSecConfig.getObject(), clients, (HttpActionAdapter)JEEHttpActionAdapter.INSTANCE);
        interceptor.setMatchers("securityheaders");
        interceptor.setAuthorizers("isFullyAuthenticated");
        interceptor.setSecurityLogic((SecurityLogic)new OAuth20AccessTokenSecurityLogic());
        return interceptor;
    }

    @ConditionalOnMissingBean(name={"oauthHandlerInterceptorAdapter"})
    @Bean
    @RefreshScope
    public HandlerInterceptor oauthHandlerInterceptorAdapter() {
        return new OAuth20HandlerInterceptorAdapter(this.requiresAuthenticationAccessTokenInterceptor(), this.requiresAuthenticationAuthorizeInterceptor(), this.accessTokenGrantRequestExtractors, (ServicesManager)this.servicesManager.getObject(), ((Config)this.oauthSecConfig.getObject()).getSessionStore(), this.oauthAuthorizationRequestValidators);
    }

    @Bean
    @ConditionalOnMissingBean(name={"oauthThrottleWebMvcConfigurer"})
    public WebMvcConfigurer oauthThrottleWebMvcConfigurer() {
        return new WebMvcConfigurer(){

            public void addInterceptors(InterceptorRegistry registry) {
                ((AuthenticationThrottlingExecutionPlan)CasOAuth20ThrottleConfiguration.this.authenticationThrottlingExecutionPlan.getObject()).getAuthenticationThrottleInterceptors().forEach(handler -> registry.addInterceptor(handler).order(0).addPathPatterns(new String[]{"/oauth2.0".concat("/*")}));
                registry.addInterceptor(CasOAuth20ThrottleConfiguration.this.oauthHandlerInterceptorAdapter()).order(1).addPathPatterns(new String[]{"/oauth2.0".concat("/*")});
            }
        };
    }

    public static class OAuth20AccessTokenSecurityLogic
    extends DefaultSecurityLogic {
        public Object perform(WebContext context, SessionStore sessionStore, Config config, SecurityGrantedAccessAdapter securityGrantedAccessAdapter, HttpActionAdapter httpActionAdapter, String clients, String authorizers, String matchers, Object ... parameters) {
            ProfileManager manager = this.getProfileManager(context, sessionStore);
            manager.setConfig(config);
            manager.removeProfiles();
            return super.perform(context, sessionStore, config, securityGrantedAccessAdapter, httpActionAdapter, clients, authorizers, matchers, parameters);
        }
    }
}

