/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.stream.Collectors;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20AuthorizationRequestValidator;
import org.apereo.cas.support.oauth.web.OAuth20HandlerInterceptorAdapter;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.apereo.cas.support.oauth.web.OAuth20TicketGrantingTicketAwareSecurityLogic;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenGrantRequestExtractor;
import org.apereo.cas.throttle.AuthenticationThrottlingExecutionPlan;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.spring.RefreshableHandlerInterceptor;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.SecurityLogicInterceptor;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.DirectClient;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.engine.DefaultSecurityLogic;
import org.pac4j.core.engine.SecurityLogic;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.OAuth})
@AutoConfiguration
public class CasOAuth20ThrottleConfiguration {

    @Configuration(value="CasOAuth20ThrottleInterceptorConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasOAuth20ThrottleInterceptorConfiguration {
        @ConditionalOnMissingBean(name={"requiresAuthenticationAuthorizeInterceptor"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public HandlerInterceptor requiresAuthenticationAuthorizeInterceptor(@Qualifier(value="oauthSecConfig") Config oauthSecConfig, @Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry) {
            OAuth20TicketGrantingTicketAwareSecurityLogic logic = new OAuth20TicketGrantingTicketAwareSecurityLogic(ticketGrantingTicketCookieGenerator, ticketRegistry);
            return new SecurityLogicInterceptor(oauthSecConfig.withSecurityLogic((SecurityLogic)logic), "CasOAuthClient");
        }

        @ConditionalOnMissingBean(name={"requiresAuthenticationAccessTokenInterceptor"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public HandlerInterceptor requiresAuthenticationAccessTokenInterceptor(@Qualifier(value="oauthSecConfig") Config oauthSecConfig) {
            String clients = oauthSecConfig.getClients().findAllClients().stream().filter(DirectClient.class::isInstance).map(Client::getName).collect(Collectors.joining(","));
            DefaultSecurityLogic logic = new DefaultSecurityLogic();
            logic.setLoadProfilesFromSession(false);
            return new SecurityLogicInterceptor(oauthSecConfig.withSecurityLogic((SecurityLogic)logic), clients);
        }
    }

    @Configuration(value="CasOAuth20ThrottleMvcConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasOAuth20ThrottleMvcConfiguration {
        @ConditionalOnMissingBean(name={"oauthHandlerInterceptorAdapter"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public HandlerInterceptor oauthHandlerInterceptorAdapter(@Qualifier(value="oauthRequestParameterResolver") ObjectProvider<OAuth20RequestParameterResolver> oauthRequestParameterResolver, @Qualifier(value="requiresAuthenticationAuthorizeInterceptor") ObjectProvider<HandlerInterceptor> requiresAuthenticationAuthorizeInterceptor, @Qualifier(value="requiresAuthenticationAccessTokenInterceptor") ObjectProvider<HandlerInterceptor> requiresAuthenticationAccessTokenInterceptor, ObjectProvider<List<OAuth20AuthorizationRequestValidator>> oauthAuthorizationRequestValidators, ObjectProvider<List<AccessTokenGrantRequestExtractor>> accessTokenGrantRequestExtractors, @Qualifier(value="oauthDistributedSessionStore") ObjectProvider<SessionStore> oauthDistributedSessionStore, @Qualifier(value="servicesManager") ObjectProvider<ServicesManager> servicesManager) {
            return new OAuth20HandlerInterceptorAdapter(requiresAuthenticationAccessTokenInterceptor, requiresAuthenticationAuthorizeInterceptor, accessTokenGrantRequestExtractors, servicesManager, oauthDistributedSessionStore, oauthAuthorizationRequestValidators, oauthRequestParameterResolver);
        }

        @Bean
        @ConditionalOnMissingBean(name={"oauthWebMvcConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public WebMvcConfigurer oauthWebMvcConfigurer(final @Qualifier(value="oauthHandlerInterceptorAdapter") ObjectProvider<HandlerInterceptor> oauthHandlerInterceptorAdapter) {
            return new WebMvcConfigurer(){

                public void addInterceptors(@Nonnull InterceptorRegistry registry) {
                    RefreshableHandlerInterceptor handler = new RefreshableHandlerInterceptor(oauthHandlerInterceptorAdapter);
                    registry.addInterceptor((HandlerInterceptor)handler).order(1).addPathPatterns(new String[]{"/oauth2.0".concat("/*")});
                }
            };
        }
    }

    @Configuration(value="CasOAuth20ThrottlePlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @AutoConfigureOrder(value=0x7FFFFFFF)
    public static class CasOAuth20ThrottlePlanConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"oauthThrottleWebMvcConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public WebMvcConfigurer oauthThrottleWebMvcConfigurer(final @Qualifier(value="authenticationThrottlingExecutionPlan") ObjectProvider<AuthenticationThrottlingExecutionPlan> authenticationThrottlingExecutionPlan) {
            return new WebMvcConfigurer(){

                public void addInterceptors(@Nonnull InterceptorRegistry registry) {
                    authenticationThrottlingExecutionPlan.ifAvailable(plan -> {
                        RefreshableHandlerInterceptor handler = new RefreshableHandlerInterceptor(() -> ((AuthenticationThrottlingExecutionPlan)plan).getAuthenticationThrottleInterceptors());
                        registry.addInterceptor((HandlerInterceptor)handler).order(0).addPathPatterns(new String[]{"/oauth2.0".concat("/*")});
                    });
                }
            };
        }
    }
}

