/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.authentication.principal.DefaultPrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.config.OidcCasClientRedirectActionBuilder;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuthCasClientRedirectActionBuilder;
import org.apereo.cas.support.oauth.validator.OAuthValidator;
import org.apereo.cas.support.oauth.web.AccessTokenResponseGenerator;
import org.apereo.cas.support.oauth.web.ConsentApprovalViewResolver;
import org.apereo.cas.support.oauth.web.OAuth20CallbackAuthorizeViewResolver;
import org.apereo.cas.ticket.accesstoken.AccessTokenFactory;
import org.apereo.cas.ticket.code.OAuthCodeFactory;
import org.apereo.cas.ticket.refreshtoken.RefreshTokenFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.OidcAuthorizationRequestSupport;
import org.apereo.cas.web.OidcAccessTokenResponseGenerator;
import org.apereo.cas.web.OidcConsentApprovalViewResolver;
import org.apereo.cas.web.controllers.OidcAccessTokenEndpointController;
import org.apereo.cas.web.controllers.OidcAuthorizeEndpointController;
import org.apereo.cas.web.controllers.OidcJwksEndpointController;
import org.apereo.cas.web.controllers.OidcProfileEndpointController;
import org.apereo.cas.web.controllers.OidcWellKnownEndpointController;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator;
import org.pac4j.cas.client.CasClient;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.springframework.web.SecurityInterceptor;
import org.springframework.beans.factory.annotation.Autowire;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.view.RedirectView;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

@Configuration(value="oidcConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class OidcConfiguration
extends WebMvcConfigurerAdapter {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="oauthInterceptor")
    private HandlerInterceptor oauthInterceptor;
    @Autowired
    @Qualifier(value="oauthSecConfig")
    private Config oauthSecConfig;
    @Autowired
    @Qualifier(value="ticketGrantingTicketCookieGenerator")
    private CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator;
    @Autowired
    @Qualifier(value="defaultTicketRegistrySupport")
    private TicketRegistrySupport ticketRegistrySupport;
    @Autowired
    @Qualifier(value="defaultAccessTokenFactory")
    private AccessTokenFactory defaultAccessTokenFactory;
    @Autowired
    @Qualifier(value="defaultRefreshTokenFactory")
    private RefreshTokenFactory defaultRefreshTokenFactory;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="ticketRegistry")
    private TicketRegistry ticketRegistry;
    @Autowired
    @Qualifier(value="oAuthValidator")
    private OAuthValidator oAuthValidator;
    @Autowired
    @Qualifier(value="defaultOAuthCodeFactory")
    private OAuthCodeFactory defaultOAuthCodeFactory;

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(this.oidcInterceptor()).addPathPatterns(new String[]{'/' + "oidc".concat("/").concat("*")});
    }

    @Bean
    public ConsentApprovalViewResolver consentApprovalViewResolver() {
        OidcConsentApprovalViewResolver c = new OidcConsentApprovalViewResolver();
        c.setOidcAuthzRequestSupport(this.oidcAuthorizationRequestSupport());
        return c;
    }

    @Bean
    public OAuth20CallbackAuthorizeViewResolver callbackAuthorizeViewResolver() {
        return new OAuth20CallbackAuthorizeViewResolver(){

            public ModelAndView resolve(J2EContext ctx, ProfileManager manager, String url) {
                OidcConfiguration.this.oidcAuthorizationRequestSupport();
                Set<String> prompts = OidcAuthorizationRequestSupport.getOidcPromptFromAuthorizationRequest(url);
                if (prompts.contains("none")) {
                    if (manager.get(true) != null) {
                        return new ModelAndView(url);
                    }
                    HashMap<String, String> model = new HashMap<String, String>();
                    model.put("error", "login_required");
                    return new ModelAndView((View)new MappingJackson2JsonView(), model);
                }
                return new ModelAndView((View)new RedirectView(url));
            }
        };
    }

    @Bean
    public HandlerInterceptor oidcInterceptor() {
        return this.oauthInterceptor;
    }

    @Bean(autowire=Autowire.BY_NAME)
    public OAuthCasClientRedirectActionBuilder oauthCasClientRedirectActionBuilder() {
        OidcCasClientRedirectActionBuilder builder = new OidcCasClientRedirectActionBuilder();
        builder.setOidcAuthorizationRequestSupport(this.oidcAuthorizationRequestSupport());
        return builder;
    }

    @Bean
    public SecurityInterceptor requiresAuthenticationAuthorizeInterceptor() {
        String name = ((CasClient)this.oauthSecConfig.getClients().findClient(CasClient.class)).getName();
        return new SecurityInterceptor(this.oauthSecConfig, name){

            public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
                J2EContext ctx = new J2EContext(request, response);
                ProfileManager manager = new ProfileManager((WebContext)ctx);
                boolean clearCreds = false;
                OidcConfiguration.this.oidcAuthorizationRequestSupport();
                Optional<UserProfile> auth = OidcAuthorizationRequestSupport.isAuthenticationProfileAvailable((WebContext)ctx);
                if (auth.isPresent()) {
                    OidcConfiguration.this.oidcAuthorizationRequestSupport();
                    Optional<Long> maxAge = OidcAuthorizationRequestSupport.getOidcMaxAgeFromAuthorizationRequest((WebContext)ctx);
                    if (maxAge.isPresent()) {
                        clearCreds = OidcConfiguration.this.oidcAuthorizationRequestSupport().isCasAuthenticationOldForMaxAgeAuthorizationRequest((WebContext)ctx, auth.get());
                    }
                }
                OidcConfiguration.this.oidcAuthorizationRequestSupport();
                Set<String> prompts = OidcAuthorizationRequestSupport.getOidcPromptFromAuthorizationRequest((WebContext)ctx);
                if (!clearCreds) {
                    clearCreds = prompts.contains("login");
                }
                if (clearCreds) {
                    boolean bl = clearCreds = !prompts.contains("none");
                }
                if (clearCreds) {
                    manager.remove(true);
                }
                return super.preHandle(request, response, handler);
            }
        };
    }

    @Bean
    public OAuthCasClientRedirectActionBuilder oidcCasClientRedirectActionBuilder() {
        return new OidcCasClientRedirectActionBuilder();
    }

    @Bean
    @RefreshScope
    public AccessTokenResponseGenerator oidcAccessTokenResponseGenerator() {
        OidcAccessTokenResponseGenerator gen = new OidcAccessTokenResponseGenerator();
        gen.setIssuer(this.casProperties.getAuthn().getOidc().getIssuer());
        gen.setJwksFile(this.casProperties.getAuthn().getOidc().getJwksFile());
        gen.setSkew(this.casProperties.getAuthn().getOidc().getSkew());
        return gen;
    }

    @Bean
    public OidcAuthorizationRequestSupport oidcAuthorizationRequestSupport() {
        OidcAuthorizationRequestSupport s = new OidcAuthorizationRequestSupport();
        s.setTicketGrantingTicketCookieGenerator(this.ticketGrantingTicketCookieGenerator);
        s.setTicketRegistrySupport(this.ticketRegistrySupport);
        return s;
    }

    @Bean
    public PrincipalFactory oidcPrincipalFactory() {
        return new DefaultPrincipalFactory();
    }

    @RefreshScope
    @Bean
    public OidcAccessTokenEndpointController oidcAccessTokenController() {
        OidcAccessTokenEndpointController c = new OidcAccessTokenEndpointController();
        c.setAccessTokenResponseGenerator(this.oidcAccessTokenResponseGenerator());
        c.setAccessTokenFactory(this.defaultAccessTokenFactory);
        c.setPrincipalFactory(this.oidcPrincipalFactory());
        c.setRefreshTokenFactory(this.defaultRefreshTokenFactory);
        c.setServicesManager(this.servicesManager);
        c.setTicketRegistry(this.ticketRegistry);
        c.setValidator(this.oAuthValidator);
        return c;
    }

    @RefreshScope
    @Bean
    public OidcJwksEndpointController oidcJwksController() {
        OidcJwksEndpointController c = new OidcJwksEndpointController();
        c.setJwksFile(this.casProperties.getAuthn().getOidc().getJwksFile());
        c.setPrincipalFactory(this.oidcPrincipalFactory());
        c.setAccessTokenFactory(this.defaultAccessTokenFactory);
        c.setServicesManager(this.servicesManager);
        c.setTicketRegistry(this.ticketRegistry);
        c.setValidator(this.oAuthValidator);
        return c;
    }

    @RefreshScope
    @Bean
    public OidcWellKnownEndpointController oidcWellKnownController() {
        OidcWellKnownEndpointController c = new OidcWellKnownEndpointController();
        c.setPrincipalFactory(this.oidcPrincipalFactory());
        c.setAccessTokenFactory(this.defaultAccessTokenFactory);
        c.setServicesManager(this.servicesManager);
        c.setTicketRegistry(this.ticketRegistry);
        c.setValidator(this.oAuthValidator);
        return c;
    }

    @RefreshScope
    @Bean
    public OidcProfileEndpointController oidcProfileController() {
        OidcProfileEndpointController c = new OidcProfileEndpointController();
        c.setAccessTokenFactory(this.defaultAccessTokenFactory);
        c.setServicesManager(this.servicesManager);
        c.setTicketRegistry(this.ticketRegistry);
        c.setValidator(this.oAuthValidator);
        c.setPrincipalFactory(this.oidcPrincipalFactory());
        return c;
    }

    @RefreshScope
    @Bean
    public OidcAuthorizeEndpointController oidcAuthorizeController() {
        OidcAuthorizeEndpointController c = new OidcAuthorizeEndpointController();
        c.setAccessTokenFactory(this.defaultAccessTokenFactory);
        c.setServicesManager(this.servicesManager);
        c.setTicketRegistry(this.ticketRegistry);
        c.setValidator(this.oAuthValidator);
        c.setPrincipalFactory(this.oidcPrincipalFactory());
        c.setConsentApprovalViewResolver(this.consentApprovalViewResolver());
        c.setoAuthCodeFactory(this.defaultOAuthCodeFactory);
        return c;
    }
}

